/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionMode;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpAuthorizationProviderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyBroadCastMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

public class JettyHttpMessageSenderProvider
implements ProtocolMessageSenderProvider {
    private final HttpClient httpClient;
    private final EndpointAddressResolver endpointAddressResolver;
    private final MetadataAppender<Request> metadataAppender;
    private final HttpAuthorizationProviderFactory authorizationProviderFactory;

    @Inject
    public JettyHttpMessageSenderProvider(HttpClient httpClient, EndpointAddressResolver endpointAddressResolver, MetadataAppender<Request> metadataAppender, HttpAuthorizationProviderFactory authorizationProviderFactory) {
        this.httpClient = httpClient;
        this.endpointAddressResolver = endpointAddressResolver;
        this.metadataAppender = metadataAppender;
        this.authorizationProviderFactory = authorizationProviderFactory;
    }

    @Override
    public MessageSender create(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        EndpointAddressResolverMetadata endpointAddressResolverMetadata = subscription.getEndpointAddressResolverMetadata();
        ResolvableEndpointAddress resolvableEndpoint = new ResolvableEndpointAddress(endpoint, this.endpointAddressResolver, endpointAddressResolverMetadata);
        HttpRequestFactory requestFactory = this.httpRequestFactory(subscription);
        if (subscription.getMode() == SubscriptionMode.BROADCAST) {
            return new JettyBroadCastMessageSender(requestFactory, resolvableEndpoint);
        }
        return new JettyMessageSender(requestFactory, resolvableEndpoint);
    }

    private HttpRequestFactory httpRequestFactory(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        int requestTimeout = subscription.getSerialSubscriptionPolicy().getRequestTimeout();
        return new HttpRequestFactory(this.httpClient, requestTimeout, this.metadataAppender, this.authorizationProviderFactory.create(endpoint));
    }

    @Override
    public void start() throws Exception {
        if (this.httpClient.isStopped()) {
            this.httpClient.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.httpClient.isRunning()) {
            this.httpClient.stop();
        }
    }
}

