/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.math.Fraction;

public class DeliveryCounters {
    private final AtomicInteger successes = new AtomicInteger(0);
    private final AtomicInteger failures = new AtomicInteger(0);

    public DeliveryCounters incrementFailures() {
        this.failures.incrementAndGet();
        return this;
    }

    public DeliveryCounters incrementSuccesses() {
        this.successes.incrementAndGet();
        return this;
    }

    public void reset() {
        this.failures.set(0);
        this.successes.set(0);
    }

    public boolean noFailures() {
        return this.failures.intValue() == 0;
    }

    public boolean hasFailures() {
        return this.failures.intValue() > 0;
    }

    public boolean majorityOfFailures() {
        return this.failures.intValue() > this.successes.intValue();
    }

    public boolean onlySuccessess() {
        return this.successes.intValue() > 0 && this.failures.intValue() == 0;
    }

    public boolean failuresRatioExceeds(double threshold) {
        if (this.hasFailures()) {
            Fraction failuresRatio = Fraction.getFraction((int)this.failures.intValue(), (int)(this.failures.intValue() + this.successes.intValue()));
            return failuresRatio.compareTo((Object)Fraction.getFraction((double)threshold)) > 0;
        }
        return false;
    }
}

