/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.Optional;
import pl.allegro.tech.hermes.api.SubscriptionName;

public class Signal {
    private final SignalType type;
    private final SubscriptionName target;
    private final Optional<Object> payload;

    private Signal(SignalType type, SubscriptionName target, Optional<Object> payload) {
        this.type = type;
        this.target = target;
        this.payload = payload;
    }

    public static Signal of(SignalType type, SubscriptionName target, Object payload) {
        return new Signal(type, target, Optional.of(payload));
    }

    public static Signal of(SignalType type, SubscriptionName target) {
        return new Signal(type, target, Optional.empty());
    }

    public SignalType getType() {
        return this.type;
    }

    public SubscriptionName getTarget() {
        return this.target;
    }

    public <T> Optional<T> getPayload() {
        return this.payload;
    }

    public <T> T getExtractedPayload() {
        return (T)this.payload.get();
    }

    public String toString() {
        return "Signal{type=" + (Object)((Object)this.type) + ", target=" + this.target + '}';
    }

    public static enum SignalType {
        START,
        RESTART,
        STOP,
        RETRANSMIT,
        UPDATE_SUBSCRIPTION,
        UPDATE_TOPIC,
        KILL_RESTART,
        CLEANUP;

    }
}

