/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;

public class SubscriptionAssignmentPathSerializer {
    private final String prefix;

    public SubscriptionAssignmentPathSerializer(String prefix) {
        this.prefix = prefix;
    }

    public String serialize(SubscriptionName subscriptionName, String supervisorId) {
        return Joiner.on((String)"/").join((Object)this.prefix, (Object)subscriptionName, new Object[]{supervisorId});
    }

    public String serialize(SubscriptionName subscriptionName) {
        return Joiner.on((String)"/").join((Object)this.prefix, (Object)subscriptionName, new Object[0]);
    }

    public SubscriptionAssignment deserialize(String path) {
        String[] paths = path.split("/");
        Preconditions.checkArgument((paths.length > 1 ? 1 : 0) != 0, (String)"Incorrect path format. Expected:'/base/subscription/supervisorId'. Found:'%s'", (Object[])new Object[]{path});
        return new SubscriptionAssignment(paths[paths.length - 1], SubscriptionName.fromString((String)paths[paths.length - 2]));
    }
}

