/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class SubscriptionAssignmentRegistryFactory
implements Factory<SubscriptionAssignmentRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionAssignmentRegistryFactory.class);
    private final CuratorFramework curatorClient;
    private final ConfigFactory configFactory;
    private final SubscriptionsCache cache;

    @Inject
    public SubscriptionAssignmentRegistryFactory(@Named(value="hermesCurator") CuratorFramework curatorClient, ConfigFactory configFactory, SubscriptionsCache cache) {
        this.curatorClient = curatorClient;
        this.configFactory = configFactory;
        this.cache = cache;
    }

    public SubscriptionAssignmentRegistry provide() {
        ZookeeperPaths paths = new ZookeeperPaths(this.configFactory.getStringProperty(Configs.ZOOKEEPER_ROOT));
        String cluster = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
        SubscriptionAssignmentRegistry registry = new SubscriptionAssignmentRegistry(this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID), this.curatorClient, paths.consumersRuntimePath(cluster), this.cache, new SubscriptionAssignmentPathSerializer(paths.consumersRuntimePath(cluster)));
        return registry;
    }

    public void dispose(SubscriptionAssignmentRegistry instance) {
        try {
            instance.stop();
        }
        catch (Exception e) {
            logger.warn("Unable to stop subscription assignment registry", (Throwable)e);
        }
    }
}

