/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.component.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.hook.HooksHandler;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapperHolder;
import pl.allegro.tech.hermes.consumers.HermesConsumersBuilder;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.health.HealthCheckServer;
import pl.allegro.tech.hermes.consumers.supervisor.monitor.ConsumersRuntimeMonitor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;
import pl.allegro.tech.hermes.tracker.consumers.LogRepository;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class HermesConsumers {
    private static final Logger logger = LoggerFactory.getLogger(HermesConsumers.class);
    private final HooksHandler hooksHandler;
    private final HealthCheckServer healthCheckServer;
    private final Trackers trackers;
    private final List<Function<ServiceLocator, LogRepository>> logRepositories;
    private final Optional<Function<ServiceLocator, KafkaNamesMapper>> kafkaNamesMapper;
    private final MultiMap<String, Function<ServiceLocator, ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers;
    private final MessageSenderFactory messageSenderFactory;
    private final ServiceLocator serviceLocator;
    private final SupervisorController supervisorController;

    public static void main(String ... args) {
        HermesConsumers.consumers().build().start();
    }

    HermesConsumers(HooksHandler hooksHandler, List<Binder> binders, MultiMap<String, Function<ServiceLocator, ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers, List<Function<ServiceLocator, LogRepository>> logRepositories, Optional<Function<ServiceLocator, KafkaNamesMapper>> kafkaNamesMapper) {
        this.hooksHandler = hooksHandler;
        this.messageSenderProvidersSuppliers = messageSenderProvidersSuppliers;
        this.logRepositories = logRepositories;
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.serviceLocator = this.createDIContainer(binders);
        this.trackers = (Trackers)this.serviceLocator.getService(Trackers.class, new Annotation[0]);
        this.healthCheckServer = (HealthCheckServer)this.serviceLocator.getService(HealthCheckServer.class, new Annotation[0]);
        this.messageSenderFactory = (MessageSenderFactory)this.serviceLocator.getService(MessageSenderFactory.class, new Annotation[0]);
        this.supervisorController = (SupervisorController)this.serviceLocator.getService(SupervisorController.class, new Annotation[0]);
        hooksHandler.addShutdownHook(s -> {
            try {
                this.healthCheckServer.stop();
                this.supervisorController.shutdown();
                s.shutdown();
            }
            catch (Exception e) {
                logger.error("Exception while shutdown Hermes Consumers", (Throwable)e);
            }
        });
    }

    public void start() {
        try {
            this.logRepositories.forEach(serviceLocatorLogRepositoryFunction -> this.trackers.add((LogRepository)serviceLocatorLogRepositoryFunction.apply(this.serviceLocator)));
            this.messageSenderProvidersSuppliers.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(supplier -> this.messageSenderFactory.addSupportedProtocol((String)entry.getKey(), (ProtocolMessageSenderProvider)supplier.apply(this.serviceLocator))));
            this.kafkaNamesMapper.ifPresent(it -> ((KafkaNamesMapperHolder)this.serviceLocator.getService(KafkaNamesMapper.class, new Annotation[0])).setKafkaNamespaceMapper((KafkaNamesMapper)it.apply(this.serviceLocator)));
            this.supervisorController.start();
            ((ConsumersRuntimeMonitor)this.serviceLocator.getService(ConsumersRuntimeMonitor.class, new Annotation[0])).start();
            this.healthCheckServer.start();
            this.hooksHandler.startup(this.serviceLocator);
        }
        catch (Exception e) {
            logger.error("Exception while starting Hermes Consumers", (Throwable)e);
        }
    }

    public void stop() {
        this.hooksHandler.shutdown(this.serviceLocator);
    }

    private ServiceLocator createDIContainer(List<Binder> binders) {
        String uniqueName = "HermesConsumersLocator" + UUID.randomUUID();
        return ServiceLocatorUtilities.bind((String)uniqueName, (Binder[])binders.toArray(new Binder[binders.size()]));
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.serviceLocator.getService(clazz, new Annotation[0]);
    }

    public <T> T getService(Class<T> clazz, String name) {
        return (T)this.serviceLocator.getService(clazz, name, new Annotation[0]);
    }

    public static HermesConsumersBuilder consumers() {
        return new HermesConsumersBuilder();
    }
}

