/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Header;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.domain.topic.schema.CompiledSchema;

public class Message {
    private String id;
    private PartitionOffset partitionOffset;
    private String topic;
    private ContentType contentType;
    private Optional<CompiledSchema<Object>> schema;
    private long publishingTimestamp;
    private long readingTimestamp;
    private byte[] data;
    private int retryCounter = 0;
    private Map<String, String> externalMetadata = Collections.emptyMap();
    private List<Header> additionalHeaders = Collections.emptyList();
    private Set<String> succeededUris = Sets.newHashSet();

    private Message() {
    }

    public Message(String id, String topic, byte[] content, ContentType contentType, Optional<CompiledSchema<Object>> schema, long publishingTimestamp, long readingTimestamp, PartitionOffset partitionOffset, Map<String, String> externalMetadata, List<Header> additionalHeaders) {
        this.id = id;
        this.data = content;
        this.topic = topic;
        this.contentType = contentType;
        this.schema = schema;
        this.publishingTimestamp = publishingTimestamp;
        this.readingTimestamp = readingTimestamp;
        this.partitionOffset = partitionOffset;
        this.externalMetadata = ImmutableMap.copyOf(externalMetadata);
        this.additionalHeaders = ImmutableList.copyOf(additionalHeaders);
    }

    public long getPublishingTimestamp() {
        return this.publishingTimestamp;
    }

    public long getReadingTimestamp() {
        return this.readingTimestamp;
    }

    public long getOffset() {
        return this.partitionOffset.getOffset();
    }

    public byte[] getData() {
        return this.data;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public int getPartition() {
        return this.partitionOffset.getPartition();
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isTtlExceeded(long ttlMillis) {
        long currentTimestamp = System.currentTimeMillis();
        return currentTimestamp > this.readingTimestamp + ttlMillis;
    }

    public void incrementRetryCounter(Collection<URI> succeededUris) {
        ++this.retryCounter;
        this.succeededUris.addAll(succeededUris.stream().map(URI::toString).collect(Collectors.toList()));
    }

    public int getRetryCounter() {
        return this.retryCounter;
    }

    public <T> Optional<CompiledSchema<T>> getSchema() {
        return this.schema.map(schema -> schema);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getExternalMetadata() {
        return Collections.unmodifiableMap(this.externalMetadata);
    }

    public List<Header> getAdditionalHeaders() {
        return Collections.unmodifiableList(this.additionalHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.id, other.id);
    }

    public static Builder message() {
        return new Builder();
    }

    public KafkaTopicName getKafkaTopic() {
        return this.partitionOffset.getTopic();
    }

    public PartitionOffset getPartitionOffset() {
        return this.partitionOffset;
    }

    public boolean hasNotBeenSentTo(String uri) {
        return !this.succeededUris.contains(uri);
    }

    static /* synthetic */ byte[] access$202(Message x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    public static class Builder {
        private final Message message = new Message();

        public Builder fromMessage(Message message) {
            this.message.id = message.getId();
            Message.access$202(this.message, message.getData());
            this.message.contentType = message.getContentType();
            this.message.topic = message.getTopic();
            this.message.publishingTimestamp = message.getPublishingTimestamp();
            this.message.readingTimestamp = message.getReadingTimestamp();
            this.message.partitionOffset = message.partitionOffset;
            this.message.externalMetadata = message.getExternalMetadata();
            this.message.additionalHeaders = message.getAdditionalHeaders();
            this.message.schema = message.getSchema();
            return this;
        }

        public Builder withData(byte[] data) {
            Message.access$202(this.message, data);
            return this;
        }

        public Builder withSchema(CompiledSchema<Object> schema) {
            this.message.schema = Optional.of(schema);
            return this;
        }

        public Builder withExternalMetadata(Map<String, String> externalMetadata) {
            this.message.externalMetadata = (Map)ImmutableMap.copyOf(externalMetadata);
            return this;
        }

        public Builder withAdditionalHeaders(List<Header> additionalHeaders) {
            this.message.additionalHeaders = (List)ImmutableList.copyOf(additionalHeaders);
            return this;
        }

        public Builder withContentType(ContentType contentType) {
            this.message.contentType = contentType;
            return this;
        }

        public Builder withNoSchema() {
            this.message.schema = Optional.empty();
            return this;
        }

        public Message build() {
            return this.message;
        }
    }
}

