/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.StringUtils;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.common.message.converter.AvroRecordToBytesConverter;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.FilteringException;
import pl.allegro.tech.hermes.domain.topic.schema.CompiledSchema;

public class AvroPathPredicate
implements Predicate<Message> {
    private List<String> path;
    private Pattern pattern;

    public AvroPathPredicate(String path, Pattern pattern) {
        this.path = Arrays.asList(StringUtils.strip((String)path, (String)".").split("\\."));
        this.pattern = pattern;
    }

    @Override
    public boolean test(Message message) {
        FilteringException.check(message.getContentType() == ContentType.AVRO, "This filter supports only AVRO contentType.");
        try {
            return this.select(message).map(this::matches).orElse(false);
        }
        catch (Exception exception) {
            throw new FilteringException(exception);
        }
    }

    private Optional<Object> select(Message message) throws IOException {
        CompiledSchema compiledSchema = message.getSchema().get();
        return this.select(AvroRecordToBytesConverter.bytesToRecord((byte[])message.getData(), (Schema)((Schema)compiledSchema.getSchema())));
    }

    private Optional<Object> select(GenericRecord record) {
        String selector;
        Object current = record;
        Iterator<String> iter = this.path.iterator();
        while (iter.hasNext() && (current = current.get(selector = iter.next())) instanceof GenericRecord) {
        }
        return iter.hasNext() ? Optional.empty() : Optional.ofNullable(current);
    }

    private boolean matches(Object value) {
        return this.pattern.matcher(Objects.toString(value)).matches();
    }
}

