/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth.client;

public class OAuthTokenRequest {
    private final String url;
    private final String grantType;
    private final String scope;
    private final String clientId;
    private final String clientSecret;
    private final String username;
    private final String password;
    private final Integer requestTimeout;

    private OAuthTokenRequest(String url, String grantType, String scope, String clientId, String clientSecret, String username, String password, Integer requestTimeout) {
        this.url = url;
        this.grantType = grantType;
        this.scope = scope;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
        this.requestTimeout = requestTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public static OAuthTokenRequestBuilder oAuthTokenRequest() {
        return new OAuthTokenRequestBuilder();
    }

    public static class OAuthTokenRequestBuilder {
        private String url;
        private String grantType;
        private String scope;
        private String clientId;
        private String clientSecret;
        private String username;
        private String password;
        private Integer requestTimeout;

        public OAuthTokenRequestBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public OAuthTokenRequestBuilder withGrantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public OAuthTokenRequestBuilder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuthTokenRequestBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuthTokenRequestBuilder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuthTokenRequestBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public OAuthTokenRequestBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public OAuthTokenRequestBuilder withRequestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public OAuthTokenRequest build() {
            return new OAuthTokenRequest(this.url, this.grantType, this.scope, this.clientId, this.clientSecret, this.username, this.password, this.requestTimeout);
        }
    }

    public static class GrantTypeValue {
        public static final String RESOURCE_OWNER_USERNAME_PASSWORD = "password";
        public static final String CLIENT_CREDENTIALS = "client_credentials";
    }

    public static class Param {
        public static final String GRANT_TYPE = "grant_type";
        public static final String SCOPE = "scope";
        public static final String CLIENT_ID = "client_id";
        public static final String CLIENT_SECRET = "client_secret";
        public static final String USERNAME = "username";
        public static final String PASSWORD = "password";
    }
}

