/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import com.google.common.util.concurrent.RateLimiter;
import java.util.Objects;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimitSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.rate.DeliveryCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculationResult;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculator;

public class SerialConsumerRateLimiter
implements ConsumerRateLimiter {
    private Subscription subscription;
    private final HermesMetrics hermesMetrics;
    private final ConsumerRateLimitSupervisor rateLimitSupervisor;
    private final RateLimiter rateLimiter;
    private final OutputRateCalculator outputRateCalculator;
    private final DeliveryCounters deliveryCounters = new DeliveryCounters();
    private OutputRateCalculator.Mode currentMode;

    public SerialConsumerRateLimiter(Subscription subscription, OutputRateCalculator outputRateCalculator, HermesMetrics hermesMetrics, ConsumerRateLimitSupervisor rateLimitSupervisor) {
        this.subscription = subscription;
        this.hermesMetrics = hermesMetrics;
        this.rateLimitSupervisor = rateLimitSupervisor;
        this.outputRateCalculator = outputRateCalculator;
        this.currentMode = OutputRateCalculator.Mode.NORMAL;
        this.rateLimiter = RateLimiter.create((double)this.calculateInitialRate().rate());
    }

    @Override
    public void initialize() {
        this.adjustConsumerRate();
        this.hermesMetrics.registerOutputRateGauge(this.subscription.getTopicName(), this.subscription.getName(), () -> ((RateLimiter)this.rateLimiter).getRate());
        this.rateLimitSupervisor.register(this);
    }

    @Override
    public void shutdown() {
        this.hermesMetrics.unregisterOutputRateGauge(this.subscription.getTopicName(), this.subscription.getName());
        this.rateLimitSupervisor.unregister(this);
    }

    @Override
    public void acquire() {
        this.rateLimiter.acquire();
    }

    @Override
    public void adjustConsumerRate() {
        OutputRateCalculationResult result = this.recalculate();
        this.rateLimiter.setRate(result.rate());
        this.currentMode = result.mode();
        this.deliveryCounters.reset();
    }

    private OutputRateCalculationResult calculateInitialRate() {
        return this.outputRateCalculator.recalculateRate(this.subscription, this.deliveryCounters, this.currentMode, 0.0);
    }

    private OutputRateCalculationResult recalculate() {
        return this.outputRateCalculator.recalculateRate(this.subscription, this.deliveryCounters, this.currentMode, this.rateLimiter.getRate());
    }

    @Override
    public void updateSubscription(Subscription newSubscription) {
        this.subscription = newSubscription;
    }

    @Override
    public void registerSuccessfulSending() {
        this.deliveryCounters.incrementSuccesses();
    }

    @Override
    public void registerFailedSending() {
        this.deliveryCounters.incrementFailures();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerialConsumerRateLimiter that = (SerialConsumerRateLimiter)o;
        return Objects.equals(this.subscription.getQualifiedName(), that.subscription.getQualifiedName());
    }

    public int hashCode() {
        return Objects.hashCode(this.subscription.getQualifiedName());
    }
}

