/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;

class RunningConsumerProcesses {
    private final Map<SubscriptionName, RunningProcess> processes = new HashMap<SubscriptionName, RunningProcess>();

    RunningConsumerProcesses() {
    }

    void add(ConsumerProcess process, Future executionHandle) {
        this.processes.put(process.getSubscriptionName(), new RunningProcess(process, executionHandle));
    }

    void remove(SubscriptionName subscriptionName) {
        this.processes.remove(subscriptionName);
    }

    void remove(ConsumerProcess process) {
        this.processes.remove(process.getSubscriptionName());
    }

    Future getExecutionHandle(SubscriptionName subscriptionName) {
        return this.processes.get((Object)subscriptionName).executionHandle;
    }

    ConsumerProcess getProcess(SubscriptionName subscriptionName) {
        return this.processes.get((Object)subscriptionName).process;
    }

    boolean hasProcess(SubscriptionName subscriptionName) {
        return this.processes.containsKey(subscriptionName);
    }

    Stream<ConsumerProcess> stream() {
        return this.processes.values().stream().map(p -> p.process);
    }

    Set<SubscriptionName> existingConsumers() {
        return this.processes.keySet();
    }

    private static class RunningProcess {
        ConsumerProcess process;
        Future executionHandle;

        public RunningProcess(ConsumerProcess process, Future executionHandle) {
            this.process = process;
            this.executionHandle = executionHandle;
        }
    }
}

