/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.Objects;
import pl.allegro.tech.hermes.api.SubscriptionName;

public class Signal {
    private final SignalType type;
    private final SubscriptionName target;
    private final Object payload;
    private final long executeAfterTimestamp;

    private Signal(SignalType type, SubscriptionName target, Object payload, long executeAfterTimestamp) {
        this.type = type;
        this.target = target;
        this.payload = payload;
        this.executeAfterTimestamp = executeAfterTimestamp;
    }

    public static Signal of(SignalType type, SubscriptionName target, Object payload) {
        return new Signal(type, target, payload, -1L);
    }

    public static Signal of(SignalType type, SubscriptionName target) {
        return new Signal(type, target, null, -1L);
    }

    public static Signal of(SignalType type, SubscriptionName target, long executeAfterTimestamp) {
        return new Signal(type, target, null, executeAfterTimestamp);
    }

    SignalType getType() {
        return this.type;
    }

    SubscriptionName getTarget() {
        return this.target;
    }

    boolean canExecuteNow(long currentTimestamp) {
        return currentTimestamp > this.executeAfterTimestamp;
    }

    <T> T getPayload() {
        return (T)this.payload;
    }

    public String toString() {
        return "Signal{type=" + (Object)((Object)this.type) + ", target=" + this.target + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)o;
        return this.type == signal.type && Objects.equals(this.target, signal.target);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.target});
    }

    public static enum SignalType {
        START,
        STOP,
        RETRANSMIT,
        UPDATE_SUBSCRIPTION,
        UPDATE_TOPIC,
        KILL,
        RESTART,
        RESTART_UNHEALTHY,
        STOP_RESTART,
        KILL_UNHEALTHY,
        CLEANUP;

    }
}

