/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.component.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.hook.HooksHandler;
import pl.allegro.tech.hermes.consumers.HermesConsumersBuilder;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderProviders;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.health.HealthCheckServer;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SupervisorController;
import pl.allegro.tech.hermes.tracker.consumers.LogRepository;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class HermesConsumers {
    private static final Logger logger = LoggerFactory.getLogger(HermesConsumers.class);
    private final HooksHandler hooksHandler;
    private final HealthCheckServer healthCheckServer;
    private final Trackers trackers;
    private final List<Function<ServiceLocator, LogRepository>> logRepositories;
    private final MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers;
    private final MessageSenderProviders messageSendersProviders;
    private final ServiceLocator serviceLocator;
    private final SupervisorController supervisorController;

    public static void main(String ... args) {
        HermesConsumers.consumers().build().start();
    }

    HermesConsumers(HooksHandler hooksHandler, List<Binder> binders, MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers, List<Function<ServiceLocator, LogRepository>> logRepositories) {
        this.hooksHandler = hooksHandler;
        this.messageSenderProvidersSuppliers = messageSenderProvidersSuppliers;
        this.logRepositories = logRepositories;
        this.serviceLocator = this.createDIContainer(binders);
        this.trackers = (Trackers)this.serviceLocator.getService(Trackers.class, new Annotation[0]);
        this.healthCheckServer = (HealthCheckServer)this.serviceLocator.getService(HealthCheckServer.class, new Annotation[0]);
        this.messageSendersProviders = (MessageSenderProviders)this.serviceLocator.getService(MessageSenderProviders.class, new Annotation[0]);
        this.supervisorController = (SupervisorController)this.serviceLocator.getService(SupervisorController.class, new Annotation[0]);
        hooksHandler.addShutdownHook(() -> {
            try {
                this.healthCheckServer.stop();
                this.supervisorController.shutdown();
                this.serviceLocator.shutdown();
            }
            catch (InterruptedException e) {
                logger.error("Exception while shutdown Hermes Consumers", (Throwable)e);
            }
        });
    }

    public void start() {
        try {
            this.logRepositories.forEach(serviceLocatorLogRepositoryFunction -> this.trackers.add((LogRepository)serviceLocatorLogRepositoryFunction.apply(this.serviceLocator)));
            this.messageSenderProvidersSuppliers.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(supplier -> this.messageSendersProviders.put((String)entry.getKey(), (ProtocolMessageSenderProvider)supplier.get())));
            this.supervisorController.start();
            this.healthCheckServer.start();
            this.hooksHandler.startup();
        }
        catch (Exception e) {
            logger.error("Exception while starting Hermes Consumers", (Throwable)e);
        }
    }

    public void stop() {
        this.hooksHandler.shutdown();
    }

    private ServiceLocator createDIContainer(List<Binder> binders) {
        String uniqueName = "HermesConsumersLocator" + UUID.randomUUID();
        return ServiceLocatorUtilities.bind((String)uniqueName, (Binder[])binders.toArray(new Binder[binders.size()]));
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.serviceLocator.getService(clazz, new Annotation[0]);
    }

    public <T> T getService(Class<T> clazz, String name) {
        return (T)this.serviceLocator.getService(clazz, name, new Annotation[0]);
    }

    public static HermesConsumersBuilder consumers() {
        return new HermesConsumersBuilder();
    }
}

