/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter.schema;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Schema;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.schema.CouldNotLoadSchemaException;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;

public class AvroSchemaRepositoryMetadataAware {
    private final SchemaRepository<Schema> avroSchemaRepository;
    private final Map<Topic, Schema> schemasWithoutMetadata = Maps.newConcurrentMap();

    @Inject
    public AvroSchemaRepositoryMetadataAware(SchemaRepository<Schema> avroSchemaRepository) {
        this.avroSchemaRepository = avroSchemaRepository;
        avroSchemaRepository.onReload(topicWithSchema -> this.schemasWithoutMetadata.put(topicWithSchema.getTopic(), this.removeMetadataField((Schema)topicWithSchema.getSchema())));
        avroSchemaRepository.onRemove(topicWithSchema -> this.schemasWithoutMetadata.remove(topicWithSchema.getTopic()));
    }

    public Schema getSchemaWithoutMetadata(Topic topic) {
        try {
            return this.schemasWithoutMetadata.computeIfAbsent(topic, this::loadWithoutMetadata);
        }
        catch (Exception e) {
            throw new CouldNotLoadSchemaException("Could not load schema without metadata for topic " + topic.getQualifiedName(), (Throwable)e);
        }
    }

    private Schema loadWithoutMetadata(Topic topic) {
        return this.removeMetadataField((Schema)this.avroSchemaRepository.getSchema(topic));
    }

    private Schema removeMetadataField(Schema schema) {
        return Schema.createRecord(schema.getFields().stream().filter(field -> !"__metadata".equals(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue())).collect(Collectors.toList()));
    }
}

