/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.jms;

import java.util.concurrent.CompletableFuture;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.CompletableFutureAwareMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;

public class JmsMessageSender
extends CompletableFutureAwareMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(JmsMessageSender.class);
    private final String topicName;
    private final JMSContext jmsContext;

    public JmsMessageSender(JMSContext jmsContext, String destinationTopic) {
        this.jmsContext = jmsContext;
        this.topicName = destinationTopic;
    }

    @Override
    public void stop() {
        this.jmsContext.close();
    }

    @Override
    protected void sendMessage(Message msg, final CompletableFuture<MessageSendingResult> resultFuture) {
        try {
            BytesMessage message = this.jmsContext.createBytesMessage();
            message.writeBytes(msg.getData());
            message.setStringProperty(MessageMetadataHeaders.TOPIC_NAME.getCamelCaseName(), msg.getTopic());
            message.setStringProperty(MessageMetadataHeaders.MESSAGE_ID.getCamelCaseName(), msg.getId());
            CompletionListener asyncListener = new CompletionListener(){

                public void onCompletion(javax.jms.Message message) {
                    resultFuture.complete(MessageSendingResult.succeededResult());
                }

                public void onException(javax.jms.Message message, Exception exception) {
                    logger.warn(String.format("Exception while sending message to topic %s", JmsMessageSender.this.topicName), (Throwable)exception);
                    resultFuture.complete(MessageSendingResult.failedResult(exception));
                }
            };
            this.jmsContext.createProducer().setAsync(asyncListener).send((Destination)this.jmsContext.createTopic(this.topicName), (javax.jms.Message)message);
        }
        catch (JMSException | JMSRuntimeException e) {
            resultFuture.complete(MessageSendingResult.failedResult(e));
        }
    }
}

