/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workTracking;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignment;

public class SubscriptionAssignmentPathSerializer {
    private final String prefix;
    private final String supervisorId;

    public SubscriptionAssignmentPathSerializer(String prefix, String supervisorId) {
        this.prefix = prefix;
        this.supervisorId = supervisorId;
    }

    public String serialize(Subscription subscription) {
        return Joiner.on((String)"/").join((Object)this.prefix, (Object)subscription.toSubscriptionName(), new Object[]{this.supervisorId});
    }

    public SubscriptionAssignment deserialize(String path) {
        String[] paths = path.split("/");
        Preconditions.checkArgument((paths.length > 1 ? 1 : 0) != 0, (String)"Incorrect path format. Expected:'/base/subscription/supervisorId'. Found:'%s'", (Object[])new Object[]{path});
        return new SubscriptionAssignment(paths[paths.length - 1], SubscriptionName.fromString((String)paths[paths.length - 2]));
    }
}

