/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workTracking;

import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.cache.zookeeper.StartableCache;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

public class SubscriptionAssignmentRegistry
extends StartableCache<SubscriptionAssignmentAware>
implements PathChildrenCacheListener {
    private final SubscriptionRepository subscriptionRepository;
    private final String supervisorId;
    private final SubscriptionAssignmentPathSerializer pathSerializer;

    public SubscriptionAssignmentRegistry(CuratorFramework curatorClient, String path, ExecutorService executorService, SubscriptionRepository subscriptionRepository, String supervisorId, SubscriptionAssignmentPathSerializer pathSerializer) {
        super(curatorClient, path, executorService);
        this.subscriptionRepository = subscriptionRepository;
        this.supervisorId = supervisorId;
        this.pathSerializer = pathSerializer;
        this.getListenable().addListener((Object)this);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        SubscriptionAssignment path = this.pathSerializer.deserialize(event.getData().getPath());
        if (this.supervisorId.equals(path.getSupervisorId())) {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    Subscription subscription = this.subscriptionRepository.getSubscriptionDetails(path.getSubscriptionName());
                    for (SubscriptionAssignmentAware callback : this.callbacks) {
                        callback.onSubscriptionAssigned(subscription);
                    }
                    break;
                }
                case CHILD_REMOVED: {
                    for (SubscriptionAssignmentAware callback : this.callbacks) {
                        callback.onAssignmentRemoved(path.getSubscriptionName());
                    }
                    break;
                }
            }
        }
    }
}

