/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workTracking;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.LegacyMirroringSupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.MirroringSupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.WorkTracker;

public class SupervisorControllerFactory
implements Factory<SupervisorController> {
    private final ConfigFactory configs;
    private final Map<String, Provider<SupervisorController>> availableImplementations;

    @Inject
    public SupervisorControllerFactory(SubscriptionsCache subscriptionsCache, WorkTracker workTracker, ConsumersSupervisor supervisor, ConfigFactory configs) {
        this.configs = configs;
        this.availableImplementations = ImmutableMap.of((Object)"legacy.mirror", () -> new LegacyMirroringSupervisorController(supervisor, subscriptionsCache), (Object)"mirror", () -> new MirroringSupervisorController(supervisor, subscriptionsCache, workTracker));
    }

    public SupervisorController provide() {
        return (SupervisorController)this.availableImplementations.get(this.configs.getStringProperty(Configs.CONSUMER_WORKLOAD_ALGORITHM)).get();
    }

    public void dispose(SupervisorController instance) {
    }
}

