/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workTracking;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.cache.zookeeper.NodeCache;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

public class WorkTracker
extends NodeCache<SubscriptionAssignmentAware, SubscriptionAssignmentRegistry> {
    private final SubscriptionRepository subscriptionRepository;
    private final String supervisorId;
    private final SubscriptionAssignmentPathSerializer pathSerializer;

    public WorkTracker(CuratorFramework curatorClient, ObjectMapper objectMapper, String path, String supervisorId, ExecutorService executorService, SubscriptionRepository subscriptionRepository) {
        super(curatorClient, objectMapper, path, executorService);
        this.subscriptionRepository = subscriptionRepository;
        this.supervisorId = supervisorId;
        this.pathSerializer = new SubscriptionAssignmentPathSerializer(path, supervisorId);
    }

    public void forceAssignment(Subscription subscription) {
        this.askCuratorPolitely(() -> {
            String cfr_ignored_0 = (String)((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.pathSerializer.serialize(subscription));
        });
    }

    public void dropAssignment(Subscription subscription) {
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curatorClient.delete().guaranteed().forPath(this.pathSerializer.serialize(subscription));
        });
    }

    private void askCuratorPolitely(CuratorTask task) {
        try {
            task.run();
        }
        catch (KeeperException.NoNodeException | KeeperException.NodeExistsException ex) {
        }
        catch (Exception ex) {
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    protected SubscriptionAssignmentRegistry createSubcache(String path) {
        return new SubscriptionAssignmentRegistry(this.curatorClient, path, this.executorService, this.subscriptionRepository, this.supervisorId, this.pathSerializer);
    }

    static interface CuratorTask {
        public void run() throws Exception;
    }
}

