/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workTracking;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.supervisor.workTracking.WorkTracker;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class WorkTrackerFactory
implements Factory<WorkTracker> {
    private final CuratorFramework curatorClient;
    private final ConfigFactory configFactory;
    private final ObjectMapper objectMapper;
    private final SubscriptionRepository subscriptionRepository;

    @Inject
    public WorkTrackerFactory(@Named(value="hermesCurator") CuratorFramework curatorClient, ConfigFactory configFactory, ObjectMapper objectMapper, SubscriptionRepository subscriptionRepository) {
        this.curatorClient = curatorClient;
        this.configFactory = configFactory;
        this.objectMapper = objectMapper;
        this.subscriptionRepository = subscriptionRepository;
    }

    public WorkTracker provide() {
        ZookeeperPaths paths = new ZookeeperPaths(this.configFactory.getStringProperty(Configs.ZOOKEEPER_ROOT));
        ExecutorService executorService = Executors.newFixedThreadPool(this.configFactory.getIntProperty(Configs.ZOOKEEPER_CACHE_THREAD_POOL_SIZE));
        String supervisorId = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_ID);
        return new WorkTracker(this.curatorClient, this.objectMapper, paths.consumersRuntimePath(), supervisorId, executorService, this.subscriptionRepository);
    }

    public void dispose(WorkTracker instance) {
        try {
            instance.stop();
        }
        catch (IOException e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }
}

