/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class Message {
    private String id;
    private PartitionOffset partitionOffset;
    private String topic;
    private ContentType contentType;
    private long publishingTimestamp;
    private long readingTimestamp;
    private byte[] data;
    private Map<String, String> externalMetadata;

    private Message() {
    }

    public Message(String id, String topic, byte[] content, ContentType contentType, long publishingTimestamp, long readingTimestamp, PartitionOffset partitionOffset, Map<String, String> externalMetadata) {
        this.id = id;
        this.data = content;
        this.topic = topic;
        this.contentType = contentType;
        this.publishingTimestamp = publishingTimestamp;
        this.readingTimestamp = readingTimestamp;
        this.partitionOffset = partitionOffset;
        this.externalMetadata = externalMetadata;
    }

    public long getPublishingTimestamp() {
        return this.publishingTimestamp;
    }

    public long getReadingTimestamp() {
        return this.readingTimestamp;
    }

    public long getOffset() {
        return this.partitionOffset.getOffset();
    }

    public byte[] getData() {
        return this.data;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public int getPartition() {
        return this.partitionOffset.getPartition();
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isTtlExceeded(int ttlSeconds) {
        long currentTimestamp = System.currentTimeMillis();
        return currentTimestamp > this.readingTimestamp + TimeUnit.SECONDS.toMillis(ttlSeconds);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getExternalMetadata() {
        return ImmutableMap.copyOf(this.externalMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.data, this.contentType, this.publishingTimestamp, this.readingTimestamp, this.partitionOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.topic, other.topic) && Objects.equals(this.publishingTimestamp, other.publishingTimestamp) && Objects.equals(this.readingTimestamp, other.readingTimestamp) && Arrays.equals(this.data, other.data) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.partitionOffset, other.partitionOffset);
    }

    public static Builder message() {
        return new Builder();
    }

    public KafkaTopicName getKafkaTopic() {
        return this.partitionOffset.getTopic();
    }

    static /* synthetic */ byte[] access$202(Message x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    public static class Builder {
        private final Message message = new Message();

        public Builder fromMessage(Message message) {
            this.message.id = message.getId();
            Message.access$202(this.message, message.getData());
            this.message.contentType = message.getContentType();
            this.message.topic = message.getTopic();
            this.message.publishingTimestamp = message.getPublishingTimestamp();
            this.message.readingTimestamp = message.getReadingTimestamp();
            this.message.partitionOffset = message.partitionOffset;
            this.message.externalMetadata = message.getExternalMetadata();
            return this;
        }

        public Builder withData(byte[] data) {
            Message.access$202(this.message, data);
            return this;
        }

        public Builder withExternalMetadata(Map<String, String> externalMetadata) {
            this.message.externalMetadata = externalMetadata;
            return this;
        }

        public Message build() {
            return this.message;
        }

        public Builder withContentType(ContentType contentType) {
            this.message.contentType = contentType;
            return this;
        }
    }
}

