/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.UUID;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.batch.JsonMessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatchFactory;

public class ByteBufferMessageBatchFactory
implements MessageBatchFactory {
    private final ByteBufferPool bufferPool;
    private final Clock clock;

    public ByteBufferMessageBatchFactory(int minPoolSize, int increment, int maxPoolSize, Clock clock) {
        this.clock = clock;
        this.bufferPool = new ArrayByteBufferPool(minPoolSize, increment, maxPoolSize);
    }

    @Override
    public MessageBatch createBatch(Subscription subscription) {
        String id = UUID.randomUUID().toString();
        int capacity = subscription.getSubscriptionPolicy().getBatchVolume();
        ByteBuffer buffer = this.bufferPool.acquire(capacity, true);
        buffer.limit(capacity);
        switch (subscription.getContentType()) {
            case JSON: {
                return new JsonMessageBatch(id, buffer, subscription, this.clock);
            }
        }
        throw new UnsupportedOperationException(String.format("Batching is not supported yet for contentType=%s", subscription.getContentType()));
    }

    @Override
    public void destroyBatch(MessageBatch batch) {
        this.bufferPool.release(batch.getContent());
    }
}

