/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;

public class JsonMessageBatch
implements MessageBatch {
    private final Clock clock;
    private final long creationTime;
    private final int maxBatchTime;
    private final int messageTtl;
    private final int batchSize;
    private final String id;
    private final ByteBuffer byteBuffer;
    private List<PartitionOffset> partitionOffsets = new ArrayList<PartitionOffset>();
    private int elements = 0;

    public JsonMessageBatch(String id, ByteBuffer buffer, int size, int maxBatchTime, int messageTtl, Clock clock) {
        this.id = id;
        this.clock = clock;
        this.creationTime = clock.millis();
        this.maxBatchTime = maxBatchTime;
        this.messageTtl = messageTtl;
        this.batchSize = size;
        this.byteBuffer = buffer;
    }

    public JsonMessageBatch(String id, ByteBuffer buffer, Subscription subscription, Clock clock) {
        this(id, buffer, subscription.getSubscriptionPolicy().getBatchSize(), subscription.getSubscriptionPolicy().getBatchTime(), subscription.getSubscriptionPolicy().getMessageTtl(), clock);
    }

    @Override
    public boolean isFull() {
        return this.elements >= this.batchSize;
    }

    @Override
    public void append(byte[] data, PartitionOffset offset) {
        if (this.elements == 0) {
            this.byteBuffer.put("[".getBytes());
        } else {
            this.byteBuffer.put(",".getBytes());
        }
        this.byteBuffer.put(data);
        this.partitionOffsets.add(offset);
        ++this.elements;
    }

    @Override
    public boolean isReadyForDelivery() {
        return this.isFull() || this.clock.millis() - this.creationTime > (long)this.maxBatchTime && this.elements > 0;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.JSON;
    }

    @Override
    public ByteBuffer close() {
        this.byteBuffer.put("]".getBytes());
        int position = this.byteBuffer.position();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(position);
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer getContent() {
        return this.byteBuffer;
    }

    @Override
    public boolean isTtlExceeded(long deliveryStartTime) {
        return this.clock.millis() - deliveryStartTime > (long)this.messageTtl;
    }

    @Override
    public List<PartitionOffset> getPartitionOffsets() {
        return this.partitionOffsets;
    }
}

