/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter.schema;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Schema;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.schema.CouldNotLoadSchemaException;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;

public class AvroSchemaRepositoryMetadataAware {
    private final SchemaRepository<Schema> avroSchemaRepository;
    private final Map<Topic, Schemas> schemas = Maps.newConcurrentMap();

    @Inject
    public AvroSchemaRepositoryMetadataAware(SchemaRepository<Schema> avroSchemaRepository) {
        this.avroSchemaRepository = avroSchemaRepository;
        avroSchemaRepository.onReload(topicWithSchema -> this.schemas.put(topicWithSchema.getTopic(), new Schemas((Schema)topicWithSchema.getSchema())));
        avroSchemaRepository.onRemove(topicWithSchema -> this.schemas.remove(topicWithSchema.getTopic()));
    }

    public Schema getSchema(Topic topic) {
        try {
            return this.schemas.computeIfAbsent(topic, this::loadSchemas).getSchema();
        }
        catch (Exception e) {
            throw new CouldNotLoadSchemaException("Could not load schema for topic " + topic.getQualifiedName(), (Throwable)e);
        }
    }

    public Schema getSchemaWithoutMetadata(Topic topic) {
        try {
            return this.schemas.computeIfAbsent(topic, this::loadSchemas).getSchemaWithoutMetadata();
        }
        catch (Exception e) {
            throw new CouldNotLoadSchemaException("Could not load schema without metadata for topic " + topic.getQualifiedName(), (Throwable)e);
        }
    }

    private Schemas loadSchemas(Topic topic) {
        return new Schemas((Schema)this.avroSchemaRepository.getSchema(topic));
    }

    private static final class Schemas {
        private final Schema schema;
        private final Schema schemaWithoutMetadata;

        private Schemas(Schema schema) {
            this.schema = schema;
            this.schemaWithoutMetadata = this.removeMetadataField(schema);
        }

        private Schema removeMetadataField(Schema schema) {
            return Schema.createRecord(schema.getFields().stream().filter(field -> !"__metadata".equals(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue())).collect(Collectors.toList()));
        }

        public Schema getSchemaWithoutMetadata() {
            return this.schemaWithoutMetadata;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Schemas)) {
                return false;
            }
            Schemas schemas = (Schemas)o;
            return Objects.equals(this.schema, schemas.schema) && Objects.equals(this.schemaWithoutMetadata, schemas.schemaWithoutMetadata);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.schemaWithoutMetadata);
        }
    }
}

