/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionOffsetCommitQueues;
import pl.allegro.tech.hermes.consumers.consumer.result.AbstractHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultSuccessHandler
extends AbstractHandler
implements SuccessHandler {
    private final Trackers trackers;

    public DefaultSuccessHandler(SubscriptionOffsetCommitQueues offsetHelper, HermesMetrics hermesMetrics, Trackers trackers) {
        super(offsetHelper, hermesMetrics);
        this.trackers = trackers;
    }

    @Override
    public void handle(Message message, Subscription subscription, MessageSendingResult result) {
        this.offsetHelper.remove(message);
        this.updateMeters(subscription, result);
        this.updateMetrics("delivered.$group.$topic.$subscription", message, subscription);
        this.trackers.get(subscription).logSent(MessageConverter.toMessageMetadata(message, subscription));
    }

    private void updateMeters(Subscription subscription, MessageSendingResult result) {
        this.hermesMetrics.meter("meter").mark();
        this.hermesMetrics.meter("meter.$group.$topic", subscription.getTopicName()).mark();
        this.hermesMetrics.meter("meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark();
        this.hermesMetrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
    }
}

