/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.RuntimeIOException;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;

public class JettyMessageBatchSender
implements MessageBatchSender {
    private final HttpClient client;
    private final long timeout;

    public JettyMessageBatchSender(HttpClient client, long timeout) {
        this.client = client;
        this.timeout = timeout;
        try {
            client.start();
        }
        catch (Exception e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public MessageSendingResult send(MessageBatch batch, EndpointAddress address) {
        try {
            String mediaType = this.getMediaType(batch.getContentType());
            Request request = this.client.newRequest(address.getEndpoint()).method(HttpMethod.POST).header(HttpHeader.KEEP_ALIVE.toString(), "true").header(MessageMetadataHeaders.BATCH_ID.getName(), batch.getId()).header(HttpHeader.CONTENT_TYPE.toString(), mediaType).timeout(this.timeout, TimeUnit.MILLISECONDS).content((ContentProvider)new ByteBufferContentProvider(mediaType, new ByteBuffer[]{batch.getContent()}));
            return new MessageSendingResult(request.send().getStatus());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return new MessageSendingResult(e);
        }
    }

    public String getMediaType(ContentType contentType) {
        return ContentType.AVRO.equals((Object)contentType) ? "avro/binary" : "application/json";
    }
}

