/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.cache.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.cache.zookeeper.ZookeeperCacheBase;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionCallback;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.zookeeper.GroupsNodeCache;

class ZookeeperSubscriptionsCache
extends ZookeeperCacheBase
implements SubscriptionsCache {
    private final GroupsNodeCache groupsNodeCache;

    public ZookeeperSubscriptionsCache(@Named(value="hermesCurator") CuratorFramework curatorClient, ConfigFactory configFactory, ObjectMapper objectMapper) {
        super(configFactory, curatorClient);
        this.groupsNodeCache = new GroupsNodeCache(curatorClient, objectMapper, this.paths.groupsPath(), this.executorService);
    }

    @Override
    public void start(Collection<? extends SubscriptionCallback> callbacks) {
        Preconditions.checkNotNull(callbacks);
        this.checkBasePath(() -> this.groupsNodeCache.start(callbacks));
    }

    @Override
    public void stop() {
        try {
            this.groupsNodeCache.stop();
            this.executorService.shutdown();
        }
        catch (Exception ex) {
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    @Override
    public List<SubscriptionName> listActiveSubscriptionNames() {
        return this.groupsNodeCache.listActiveSubscriptionNames();
    }
}

