/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.mirror;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.admin.AdminOperationsCallback;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionCallback;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkTracker;

public class MirroringSupervisorController
implements SupervisorController {
    private ConsumersSupervisor supervisor;
    private SubscriptionsCache subscriptionsCache;
    private WorkTracker workTracker;
    private ZookeeperAdminCache adminCache;
    private ConfigFactory configFactory;
    private static final Logger logger = LoggerFactory.getLogger(MirroringSupervisorController.class);

    public MirroringSupervisorController(ConsumersSupervisor supervisor, SubscriptionsCache subscriptionsCache, WorkTracker workTracker, ZookeeperAdminCache adminCache, ConfigFactory configFactory) {
        this.supervisor = supervisor;
        this.subscriptionsCache = subscriptionsCache;
        this.workTracker = workTracker;
        this.adminCache = adminCache;
        this.configFactory = configFactory;
    }

    @Override
    public void onSubscriptionCreated(Subscription subscription) {
        this.workTracker.forceAssignment(subscription);
    }

    @Override
    public void onSubscriptionRemoved(Subscription subscription) {
        this.workTracker.dropAssignment(subscription);
    }

    @Override
    public void onSubscriptionChanged(Subscription subscription) {
        switch (subscription.getState()) {
            case PENDING: 
            case ACTIVE: {
                this.workTracker.forceAssignment(subscription);
                break;
            }
            case SUSPENDED: {
                this.workTracker.dropAssignment(subscription);
                break;
            }
        }
        this.supervisor.updateSubscription(subscription);
    }

    @Override
    public void onSubscriptionAssigned(Subscription subscription) {
        logger.info("Assigning consumer for {}", (Object)subscription.getId());
        this.supervisor.assignConsumerForSubscription(subscription);
    }

    @Override
    public void onAssignmentRemoved(SubscriptionName subscription) {
        logger.info("Removing assignment from consumer for {}", (Object)subscription.getId());
        this.supervisor.deleteConsumerForSubscriptionName(subscription);
    }

    @Override
    public void start() throws Exception {
        this.adminCache.start();
        this.adminCache.addCallback((AdminOperationsCallback)this);
        this.subscriptionsCache.start((Collection<? extends SubscriptionCallback>)ImmutableList.of((Object)this));
        this.workTracker.start((Collection)ImmutableList.of((Object)this));
        this.supervisor.start();
        logger.info("Consumer boot complete. Workload config: [{}]", (Object)this.configFactory.print(new Configs[]{Configs.CONSUMER_WORKLOAD_NODE_ID, Configs.CONSUMER_WORKLOAD_ALGORITHM}));
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.supervisor.shutdown();
    }

    public void onRetransmissionStarts(SubscriptionName subscription) throws Exception {
        this.supervisor.retransmit(subscription);
    }

    public void restartConsumer(SubscriptionName subscription) throws Exception {
        this.supervisor.restartConsumer(subscription);
    }
}

