/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.timer.ConsumerLatencyTimer;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.timeout.FutureAsyncTimeout;

public class ConsumerMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerMessageSender.class);
    private final ScheduledExecutorService retrySingleThreadExecutor;
    private final ExecutorService deliveryReportingExecutor;
    private final SuccessHandler successHandler;
    private final ErrorHandler errorHandler;
    private final ConsumerRateLimiter rateLimiter;
    private final MessageSender messageSender;
    private final Semaphore inflightSemaphore;
    private final FutureAsyncTimeout<MessageSendingResult> async;
    private final int asyncTimeoutMs;
    private ConsumerLatencyTimer consumerLatencyTimer;
    private Subscription subscription;
    private volatile boolean consumerIsConsuming = true;

    public ConsumerMessageSender(Subscription subscription, MessageSender messageSender, SuccessHandler successHandler, ErrorHandler errorHandler, ConsumerRateLimiter rateLimiter, ExecutorService deliveryReportingExecutor, Semaphore inflightSemaphore, HermesMetrics hermesMetrics, int asyncTimeoutMs, FutureAsyncTimeout<MessageSendingResult> futureAsyncTimeout) {
        this.deliveryReportingExecutor = deliveryReportingExecutor;
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
        this.rateLimiter = rateLimiter;
        this.messageSender = messageSender;
        this.subscription = subscription;
        this.inflightSemaphore = inflightSemaphore;
        this.retrySingleThreadExecutor = Executors.newScheduledThreadPool(1);
        this.async = futureAsyncTimeout;
        this.asyncTimeoutMs = asyncTimeoutMs;
        this.consumerLatencyTimer = hermesMetrics.latencyTimer(subscription);
    }

    public void shutdown() {
        this.consumerIsConsuming = false;
    }

    public void sendMessage(Message message) {
        while (this.consumerIsConsuming) {
            try {
                this.submitAsyncSendMessageRequest(message, this.consumerLatencyTimer);
                return;
            }
            catch (RuntimeException e) {
                this.handleFailedSending(message, MessageSendingResult.failedResult(e));
                if (this.consumerIsConsuming && !this.isTtlExceeded(message)) continue;
                this.handleMessageDiscarding(message, MessageSendingResult.failedResult(e));
                return;
            }
        }
    }

    public void updateSubscription(Subscription newSubscription) {
        this.subscription = newSubscription;
    }

    private void submitAsyncSendMessageRequest(Message message, ConsumerLatencyTimer consumerLatencyTimer) {
        this.rateLimiter.acquire();
        ConsumerLatencyTimer.Context timer = consumerLatencyTimer.time();
        CompletableFuture<MessageSendingResult> response = this.async.within(this.messageSender.send(message), Duration.ofMillis(this.asyncTimeoutMs));
        response.thenAcceptAsync((Consumer)new ResponseHandlingListener(message, timer), (Executor)this.deliveryReportingExecutor);
    }

    private boolean isTtlExceeded(Message message) {
        return this.willExceedTtl(message, 0L);
    }

    private boolean willExceedTtl(Message message, long delay) {
        long ttl = TimeUnit.SECONDS.toMillis(this.subscription.getSerialSubscriptionPolicy().getMessageTtl().intValue());
        long remainingTtl = Math.max(ttl - delay, 0L);
        return message.isTtlExceeded(remainingTtl);
    }

    private void handleFailedSending(Message message, MessageSendingResult result) {
        if (this.shouldReduceSendingRate(result)) {
            this.rateLimiter.registerFailedSending();
        } else {
            this.rateLimiter.registerSuccessfulSending();
        }
        this.errorHandler.handleFailed(message, this.subscription, result);
    }

    private void handleMessageDiscarding(Message message, MessageSendingResult result) {
        this.inflightSemaphore.release();
        this.errorHandler.handleDiscarded(message, this.subscription, result);
    }

    private void handleMessageSendingSuccess(Message message, MessageSendingResult result) {
        this.inflightSemaphore.release();
        this.successHandler.handle(message, this.subscription, result);
    }

    private boolean shouldReduceSendingRate(MessageSendingResult result) {
        return !result.isRetryLater() && this.subscriptionAllowsResending(result);
    }

    private boolean subscriptionAllowsResending(MessageSendingResult result) {
        return !result.succeeded() && (!result.isClientError() || this.subscription.getSerialSubscriptionPolicy().isRetryClientErrors() != false);
    }

    class ResponseHandlingListener
    implements Consumer<MessageSendingResult> {
        private final Message message;
        private final ConsumerLatencyTimer.Context timer;

        public ResponseHandlingListener(Message message, ConsumerLatencyTimer.Context timer) {
            this.message = message;
            this.timer = timer;
        }

        @Override
        public void accept(MessageSendingResult result) {
            this.timer.stop();
            if (result.succeeded()) {
                ConsumerMessageSender.this.rateLimiter.registerSuccessfulSending();
                ConsumerMessageSender.this.handleMessageSendingSuccess(this.message, result);
            } else {
                ConsumerMessageSender.this.handleFailedSending(this.message, result);
                this.message.incrementRetryCounter();
                long retryDelay = this.extractRetryDelay(result);
                if (ConsumerMessageSender.this.consumerIsConsuming && this.shouldAttemptResending(result, retryDelay)) {
                    ConsumerMessageSender.this.retrySingleThreadExecutor.schedule(() -> this.retrySending(result), retryDelay, TimeUnit.MILLISECONDS);
                } else {
                    ConsumerMessageSender.this.handleMessageDiscarding(this.message, result);
                }
            }
        }

        private boolean shouldAttemptResending(MessageSendingResult result, long retryDelay) {
            return !ConsumerMessageSender.this.willExceedTtl(this.message, retryDelay) && ConsumerMessageSender.this.subscriptionAllowsResending(result);
        }

        private long extractRetryDelay(MessageSendingResult result) {
            long defaultBackoff = ConsumerMessageSender.this.subscription.getSerialSubscriptionPolicy().getMessageBackoff().intValue();
            long ttl = TimeUnit.SECONDS.toMillis(ConsumerMessageSender.this.subscription.getSerialSubscriptionPolicy().getMessageTtl().intValue());
            return result.getRetryAfterMillis().map(delay -> Math.min(delay, ttl)).orElse(defaultBackoff);
        }

        private void retrySending(MessageSendingResult result) {
            if (result.isLoggable()) {
                logger.info(String.format("Retrying message send to endpoint %s; messageId %s; offset: %s; partition: %s; sub id: %s; rootCause: %s", ConsumerMessageSender.this.subscription.getEndpoint().getEndpoint(), this.message.getId(), this.message.getOffset(), this.message.getPartition(), ConsumerMessageSender.this.subscription.getId(), result.getRootCause()), result.getFailure());
            }
            ConsumerMessageSender.this.sendMessage(this.message);
        }
    }
}

