/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.converter.schema.AvroSchemaRepositoryMetadataAware;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;

public class AvroToJsonMessageConverter
implements MessageConverter {
    private final AvroSchemaRepositoryMetadataAware schemaRepository;
    private final JsonAvroConverter converter;

    @Inject
    public AvroToJsonMessageConverter(AvroSchemaRepositoryMetadataAware schemaRepository) {
        this.schemaRepository = schemaRepository;
        this.converter = new JsonAvroConverter();
    }

    @Override
    public Message convert(Message message, Topic topic) {
        return Message.message().fromMessage(message).withContentType(ContentType.JSON).withData(this.converter.convertToJson(this.recordWithoutMetadata(message.getData(), topic))).build();
    }

    private GenericRecord recordWithoutMetadata(byte[] data, Topic topic) {
        GenericRecord original = this.originalRecord(data, topic);
        Schema schemaWithoutMetadata = this.schemaRepository.getSchemaWithoutMetadata(topic);
        GenericRecordBuilder builder = new GenericRecordBuilder(schemaWithoutMetadata);
        schemaWithoutMetadata.getFields().forEach(field -> builder.set(field, original.get(field.name())));
        return builder.build();
    }

    private GenericRecord originalRecord(byte[] data, Topic topic) {
        try {
            BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(data, null);
            return (GenericRecord)new GenericDatumReader(this.schemaRepository.getSchema(topic)).read(null, (Decoder)binaryDecoder);
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to create avro record.", (Throwable)e);
        }
    }
}

