/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver.kafka;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.broker.BrokerOffsetsRepository;
import pl.allegro.tech.hermes.consumers.consumer.receiver.MessageCommitter;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.OffsetsStorageType;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.broker.BrokerMessageCommitter;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.zookeeper.ZookeeperMessageCommitter;

public class MessageCommitterFactory
implements Factory<List<MessageCommitter>> {
    private final OffsetsStorageType offsetsStorageType;
    private final CuratorFramework curatorFramework;
    private final BrokerOffsetsRepository brokerOffsetsRepository;
    private final KafkaNamesMapper kafkaNamesMapper;
    private final boolean dualCommitEnabled;

    @Inject
    public MessageCommitterFactory(ConfigFactory configFactory, @Named(value="kafkaCurator") CuratorFramework curatorFramework, BrokerOffsetsRepository brokerOffsetsRepository, KafkaNamesMapper kafkaNamesMapper) {
        this.curatorFramework = curatorFramework;
        this.brokerOffsetsRepository = brokerOffsetsRepository;
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.offsetsStorageType = OffsetsStorageType.valueOf(configFactory.getStringProperty(Configs.KAFKA_CONSUMER_OFFSETS_STORAGE).toUpperCase());
        this.dualCommitEnabled = configFactory.getBooleanProperty(Configs.KAFKA_CONSUMER_DUAL_COMMIT_ENABLED);
    }

    public List<MessageCommitter> provide() {
        ArrayList<MessageCommitter> committers = new ArrayList<MessageCommitter>();
        if (this.dualCommitEnabled || OffsetsStorageType.KAFKA == this.offsetsStorageType) {
            committers.add(new BrokerMessageCommitter(this.brokerOffsetsRepository));
        }
        if (this.dualCommitEnabled || OffsetsStorageType.ZOOKEEPER == this.offsetsStorageType) {
            committers.add(new ZookeeperMessageCommitter(this.curatorFramework, this.kafkaNamesMapper));
        }
        return committers;
    }

    public void dispose(List<MessageCommitter> instance) {
    }
}

