/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor;

import java.util.HashMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.consumers.supervisor.CloseableSubscriptionLock;

class SubscriptionLocks {
    private Map<String, CloseableSubscriptionLock> locks = new HashMap<String, CloseableSubscriptionLock>();

    SubscriptionLocks() {
    }

    private synchronized CloseableSubscriptionLock getLock(String subscriptionId) {
        if (!this.locks.containsKey(subscriptionId)) {
            this.locks.put(subscriptionId, new CloseableSubscriptionLock());
        }
        return this.locks.get(subscriptionId);
    }

    public CloseableSubscriptionLock lock(SubscriptionName subscriptionName) {
        return this.getLock(Subscription.getId((TopicName)subscriptionName.getTopicName(), (String)subscriptionName.getName())).autoLock();
    }

    public CloseableSubscriptionLock lock(Subscription subscription) {
        return this.getLock(subscription.getId()).autoLock();
    }
}

