/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.cache.zookeeper.NodeCache;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

public class WorkTracker
extends NodeCache<SubscriptionAssignmentAware, SubscriptionAssignmentRegistry> {
    private final SubscriptionRepository subscriptionRepository;
    private final String consumerNodeId;
    private final SubscriptionAssignmentPathSerializer pathSerializer;

    public WorkTracker(CuratorFramework curatorClient, ObjectMapper objectMapper, String path, String consumerNodeId, ExecutorService executorService, SubscriptionRepository subscriptionRepository) {
        super(curatorClient, objectMapper, path, executorService);
        this.subscriptionRepository = subscriptionRepository;
        this.consumerNodeId = consumerNodeId;
        this.pathSerializer = new SubscriptionAssignmentPathSerializer(path);
    }

    public void forceAssignment(Subscription subscription) {
        this.askCuratorPolitely(() -> {
            String cfr_ignored_0 = (String)((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.pathSerializer.serialize(subscription.toSubscriptionName(), this.consumerNodeId));
        });
    }

    public void dropAssignment(Subscription subscription) {
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curatorClient.delete().guaranteed().forPath(this.pathSerializer.serialize(subscription.toSubscriptionName(), this.consumerNodeId));
        });
    }

    private void askCuratorPolitely(CuratorTask task) {
        try {
            task.run();
        }
        catch (KeeperException.NoNodeException | KeeperException.NodeExistsException ex) {
        }
        catch (Exception ex) {
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    public WorkDistributionChanges apply(SubscriptionAssignmentView targetView) {
        SubscriptionAssignmentView currentView = this.getAssignments();
        List<SubscriptionAssignment> deletions = currentView.deletions(targetView).getAllAssignments();
        List<SubscriptionAssignment> additions = currentView.additions(targetView).getAllAssignments();
        deletions.forEach(this::dropAssignment);
        additions.forEach(this::addAssignment);
        return new WorkDistributionChanges(deletions.size(), additions.size());
    }

    private void dropAssignment(SubscriptionAssignment assignment) {
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curatorClient.delete().guaranteed().forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        });
    }

    private void addAssignment(SubscriptionAssignment assignment) {
        this.askCuratorPolitely(() -> {
            String cfr_ignored_0 = (String)((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        });
    }

    private Set<SubscriptionAssignment> getAssignments(String subscriptionName) {
        return ((SubscriptionAssignmentRegistry)this.getEntry(subscriptionName)).getCurrentData().stream().map(child -> this.pathSerializer.deserialize(child.getPath())).collect(Collectors.toSet());
    }

    public SubscriptionAssignmentView getAssignments() {
        return new SubscriptionAssignmentView(this.getSubcacheKeySet().stream().collect(Collectors.toMap(SubscriptionName::fromString, this::getAssignments)));
    }

    public boolean isAssignedTo(SubscriptionName subscription, String consumerNodeId) {
        return this.getAssignments(subscription.toString()).stream().filter(assignment -> Objects.equals(assignment.getConsumerNodeId(), consumerNodeId)).findAny().isPresent();
    }

    protected SubscriptionAssignmentRegistry createSubcache(String path) {
        return new SubscriptionAssignmentRegistry(this.curatorClient, path, this.executorService, this.subscriptionRepository, this.consumerNodeId, this.pathSerializer);
    }

    public static class WorkDistributionChanges {
        private final int deleted;
        private final int created;

        public WorkDistributionChanges(int deleted, int created) {
            this.deleted = deleted;
            this.created = created;
        }

        public int getDeletedAssignmentsCount() {
            return this.deleted;
        }

        public int getCreatedAssignmentsCount() {
            return this.created;
        }

        public String toString() {
            return String.format("assignments_created=%d, assignments_deleted=%d", this.created, this.deleted);
        }
    }

    static interface CuratorTask {
        public void run() throws Exception;
    }
}

