/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.selective;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.admin.AdminOperationsCallback;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkTracker;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.BalancingJob;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.SelectiveWorkBalancer;

public class SelectiveSupervisorController
implements SupervisorController {
    private ConsumersSupervisor supervisor;
    private SubscriptionsCache subscriptionsCache;
    private WorkTracker workTracker;
    private ConsumerNodesRegistry consumersRegistry;
    private final ZookeeperAdminCache adminCache;
    private ConfigFactory configFactory;
    private HermesMetrics metrics;
    private ExecutorService assignmentExecutor;
    private static final Logger logger = LoggerFactory.getLogger(SelectiveSupervisorController.class);

    public SelectiveSupervisorController(ConsumersSupervisor supervisor, SubscriptionsCache subscriptionsCache, WorkTracker workTracker, ConsumerNodesRegistry consumersRegistry, ZookeeperAdminCache adminCache, ExecutorService assignmentExecutor, ConfigFactory configFactory, HermesMetrics metrics) {
        this.supervisor = supervisor;
        this.subscriptionsCache = subscriptionsCache;
        this.workTracker = workTracker;
        this.consumersRegistry = consumersRegistry;
        this.adminCache = adminCache;
        this.assignmentExecutor = assignmentExecutor;
        this.configFactory = configFactory;
        this.metrics = metrics;
    }

    @Override
    public void onSubscriptionAssigned(Subscription subscription) {
        logger.info("Scheduling assignment consumer for {}", (Object)subscription.getId());
        this.assignmentExecutor.execute(() -> {
            logger.info("Assigning consumer for {}", (Object)subscription.getId());
            this.supervisor.assignConsumerForSubscription(subscription);
        });
    }

    @Override
    public void onAssignmentRemoved(SubscriptionName subscription) {
        logger.info("Scheduling assignment removal consumer for {}", (Object)subscription.getId());
        this.assignmentExecutor.execute(() -> {
            logger.info("Removing assignment from consumer for {}", (Object)subscription.getId());
            this.supervisor.deleteConsumerForSubscriptionName(subscription);
        });
    }

    @Override
    public void onSubscriptionChanged(Subscription subscription) {
        logger.info("Updating subscription {}", (Object)subscription.getId());
        this.supervisor.updateSubscription(subscription);
    }

    @Override
    public void start() throws Exception {
        this.adminCache.start();
        this.adminCache.addCallback((AdminOperationsCallback)this);
        this.subscriptionsCache.start(Collections.singleton(this));
        this.workTracker.start((Collection)ImmutableList.of((Object)this));
        this.supervisor.start();
        this.consumersRegistry.start();
        this.consumersRegistry.registerLeaderLatchListener(new BalancingJob(this.consumersRegistry, this.subscriptionsCache, new SelectiveWorkBalancer(this.configFactory.getIntProperty(Configs.CONSUMER_WORKLOAD_CONSUMERS_PER_SUBSCRIPTION), this.configFactory.getIntProperty(Configs.CONSUMER_WORKLOAD_MAX_SUBSCRIPTIONS_PER_CONSUMER)), this.workTracker, this.metrics, this.configFactory.getIntProperty(Configs.CONSUMER_WORKLOAD_REBALANCE_INTERVAL), this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME)));
        logger.info("Consumer boot complete. Workload config: [{}]", (Object)this.configFactory.print(new Configs[]{Configs.CONSUMER_WORKLOAD_NODE_ID, Configs.CONSUMER_WORKLOAD_ALGORITHM, Configs.CONSUMER_WORKLOAD_REBALANCE_INTERVAL, Configs.CONSUMER_WORKLOAD_CONSUMERS_PER_SUBSCRIPTION, Configs.CONSUMER_WORKLOAD_MAX_SUBSCRIPTIONS_PER_CONSUMER}));
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.supervisor.shutdown();
    }

    public String getId() {
        return this.consumersRegistry.getId();
    }

    public boolean isLeader() {
        return this.consumersRegistry.isLeader();
    }

    public void onRetransmissionStarts(SubscriptionName subscription) throws Exception {
        if (this.workTracker.isAssignedTo(subscription, this.getId())) {
            this.supervisor.retransmit(subscription);
        }
    }

    public void restartConsumer(SubscriptionName subscription) throws Exception {
        if (this.workTracker.isAssignedTo(subscription, this.getId())) {
            this.supervisor.restartConsumer(subscription);
        }
    }
}

