/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.selective;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.AvailableWork;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.WorkBalancingResult;

public class SelectiveWorkBalancer {
    private final int consumersPerSubscription;
    private final int maxSubscriptionsPerConsumer;

    public SelectiveWorkBalancer(int consumersPerSubscription, int maxSubscriptionsPerConsumer) {
        this.consumersPerSubscription = consumersPerSubscription;
        this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
    }

    public WorkBalancingResult balance(List<SubscriptionName> subscriptions, List<String> activeConsumerNodes, SubscriptionAssignmentView currentState) {
        List<SubscriptionName> removedSubscriptions = this.findRemovedSubscriptions(currentState, subscriptions);
        List<String> inactiveConsumers = this.findInactiveConsumers(currentState, activeConsumerNodes);
        List<SubscriptionName> newSubscriptions = this.findNewSubscriptions(currentState, subscriptions);
        List<String> newConsumers = this.findNewConsumers(currentState, activeConsumerNodes);
        SubscriptionAssignmentView balancedState = this.balance(currentState, removedSubscriptions, inactiveConsumers, newSubscriptions, newConsumers);
        return new WorkBalancingResult.Builder(balancedState).withSubscriptionsStats(subscriptions.size(), removedSubscriptions.size(), newSubscriptions.size()).withConsumersStats(activeConsumerNodes.size(), inactiveConsumers.size(), newConsumers.size()).withMissingResources(this.countMissingResources(balancedState)).build();
    }

    private SubscriptionAssignmentView balance(SubscriptionAssignmentView currentState, List<SubscriptionName> removedSubscriptions, List<String> inactiveConsumers, List<SubscriptionName> newSubscriptions, List<String> newConsumers) {
        return currentState.transform((state, transformer) -> {
            removedSubscriptions.forEach(transformer::removeSubscription);
            inactiveConsumers.forEach(transformer::removeConsumerNode);
            newSubscriptions.forEach(transformer::addSubscription);
            newConsumers.forEach(transformer::addConsumerNode);
            AvailableWork.stream(state, this.consumersPerSubscription, this.maxSubscriptionsPerConsumer).forEach(transformer::addAssignment);
            this.equalizeWorkload((SubscriptionAssignmentView)state, (SubscriptionAssignmentView.Transformer)transformer);
        });
    }

    private int countMissingResources(SubscriptionAssignmentView state) {
        return state.getSubscriptions().stream().mapToInt(s -> this.consumersPerSubscription - state.getAssignmentsCountForSubscription((SubscriptionName)s)).sum();
    }

    private void equalizeWorkload(SubscriptionAssignmentView state, SubscriptionAssignmentView.Transformer transformer) {
        if (state.getSubscriptionsCount() > 1) {
            boolean transferred;
            do {
                Optional<SubscriptionName> subscription;
                transferred = false;
                String maxLoaded = this.maxLoadedConsumerNode(state);
                String minLoaded = this.minLoadedConsumerNode(state);
                int maxLoad = state.getAssignmentsCountForConsumerNode(maxLoaded);
                int minLoad = state.getAssignmentsCountForConsumerNode(minLoaded);
                while (maxLoad > minLoad + 1 && (subscription = this.getSubscriptionForTransfer(state, maxLoaded, minLoaded)).isPresent()) {
                    transformer.transferAssignment(maxLoaded, minLoaded, subscription.get());
                    transferred = true;
                    --maxLoad;
                    ++minLoad;
                }
            } while (transferred);
        }
    }

    private String maxLoadedConsumerNode(SubscriptionAssignmentView state) {
        return state.getConsumerNodes().stream().max(Comparator.comparingInt(state::getAssignmentsCountForConsumerNode)).get();
    }

    private String minLoadedConsumerNode(SubscriptionAssignmentView state) {
        return state.getConsumerNodes().stream().min(Comparator.comparingInt(state::getAssignmentsCountForConsumerNode)).get();
    }

    private Optional<SubscriptionName> getSubscriptionForTransfer(SubscriptionAssignmentView state, String maxLoaded, String minLoaded) {
        return state.getSubscriptionsForConsumerNode(maxLoaded).stream().filter(s -> !state.getConsumerNodesForSubscription((SubscriptionName)s).contains(minLoaded)).findAny();
    }

    private List<SubscriptionName> findRemovedSubscriptions(SubscriptionAssignmentView state, List<SubscriptionName> subscriptions) {
        return state.getSubscriptions().stream().filter(s -> !subscriptions.contains(s)).collect(Collectors.toList());
    }

    private List<String> findInactiveConsumers(SubscriptionAssignmentView state, List<String> activeConsumers) {
        return state.getConsumerNodes().stream().filter(c -> !activeConsumers.contains(c)).collect(Collectors.toList());
    }

    private List<SubscriptionName> findNewSubscriptions(SubscriptionAssignmentView state, List<SubscriptionName> subscriptions) {
        return subscriptions.stream().filter(s -> !state.getSubscriptions().contains(s)).collect(Collectors.toList());
    }

    private List<String> findNewConsumers(SubscriptionAssignmentView state, List<String> activeConsumers) {
        return activeConsumers.stream().filter(c -> !state.getConsumerNodes().contains(c)).collect(Collectors.toList());
    }
}

