/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.boon.collections.ConcurrentHashSet;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;

public class ConsumerRateLimitSupervisor
implements Runnable {
    private final Set<ConsumerRateLimiter> consumerRateLimiters = new ConcurrentHashSet();

    @Inject
    public ConsumerRateLimitSupervisor(ConfigFactory configFactory) {
        int period = configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_SUPERVISOR_PERIOD);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this, period, period, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        for (ConsumerRateLimiter limiter : this.consumerRateLimiters) {
            limiter.adjustConsumerRate();
        }
    }

    public void register(ConsumerRateLimiter consumerRateLimiter) {
        this.consumerRateLimiters.add(consumerRateLimiter);
    }

    public void unregister(ConsumerRateLimiter consumerRateLimiter) {
        this.consumerRateLimiters.remove(consumerRateLimiter);
    }
}

