/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

public class JettyHttpMessageSenderProvider
implements ProtocolMessageSenderProvider {
    private final HttpClient httpClient;
    private final EndpointAddressResolver endpointAddressResolver;
    private final int requestTimeout;
    private final MetadataAppender<Request> metadataAppender;

    @Inject
    public JettyHttpMessageSenderProvider(HttpClient httpClient, ConfigFactory configFactory, EndpointAddressResolver endpointAddressResolver, MetadataAppender<Request> metadataAppender) {
        this.httpClient = httpClient;
        this.endpointAddressResolver = endpointAddressResolver;
        this.requestTimeout = configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_REQUEST_TIMEOUT);
        this.metadataAppender = metadataAppender;
    }

    @Override
    public void start() throws Exception {
        if (this.httpClient.isStopped()) {
            this.httpClient.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.httpClient.isRunning()) {
            this.httpClient.stop();
        }
    }

    @Override
    public MessageSender create(String endpoint) {
        ResolvableEndpointAddress resolvableEndpoint = new ResolvableEndpointAddress(EndpointAddress.of((String)endpoint), this.endpointAddressResolver);
        return new JettyMessageSender(this.httpClient, resolvableEndpoint, this.requestTimeout, this.metadataAppender);
    }
}

