/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.cache.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.cache.queue.QueueTask;
import pl.allegro.tech.hermes.common.cache.zookeeper.StartableCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionCallback;

class SubscriptionsNodeCache
extends StartableCache<SubscriptionCallback>
implements PathChildrenCacheListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionsNodeCache.class);
    private final ObjectMapper objectMapper;
    private final ExecutorService processingExecutor;

    public SubscriptionsNodeCache(CuratorFramework client, ObjectMapper objectMapper, String path, ExecutorService eventExecutor, ExecutorService processingExecutor) {
        super(client, path, eventExecutor);
        this.objectMapper = objectMapper;
        this.processingExecutor = processingExecutor;
        this.getListenable().addListener((Object)this);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (event.getData() == null || event.getData().getData() == null) {
            LOGGER.warn("Unrecognized event {}", (Object)event);
            return;
        }
        String path = event.getData().getPath();
        Subscription subscription = this.readSubscription(event.getData());
        LOGGER.info("Got subscription change event for path {} type {}", (Object)path, (Object)event.getType());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Event type: {}, event data {}", (Object)event.getType().toString(), (Object)new String(event.getData().getData(), Charsets.UTF_8));
        }
        switch (event.getType()) {
            case CHILD_ADDED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    this.processingExecutor.execute((Runnable)new QueueTask(() -> callback.onSubscriptionCreated(subscription), new Object[]{subscription, subscription.getState(), event.getType()}));
                }
                break;
            }
            case CHILD_REMOVED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    this.processingExecutor.execute((Runnable)new QueueTask(() -> callback.onSubscriptionRemoved(subscription), new Object[]{subscription, subscription.getState(), event.getType()}));
                }
                break;
            }
            case CHILD_UPDATED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    this.processingExecutor.execute((Runnable)new QueueTask(() -> callback.onSubscriptionChanged(subscription), new Object[]{subscription, subscription.getState(), event.getType()}));
                }
                break;
            }
        }
    }

    public List<SubscriptionName> listActiveSubscriptionNames() {
        return this.getCurrentData().stream().map(this::tryToReadSubscriptionSilently).filter(Objects::nonNull).filter(Subscription::isActive).map(Subscription::toSubscriptionName).collect(Collectors.toList());
    }

    private Subscription tryToReadSubscriptionSilently(ChildData event) {
        try {
            return this.readSubscription(event);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Subscription readSubscription(ChildData event) throws IOException {
        return (Subscription)this.objectMapper.readValue(event.getData(), Subscription.class);
    }
}

