/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.MessageMetadata;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class BatchMonitoring {
    private HermesMetrics metrics;
    private Trackers trackers;

    public BatchMonitoring(HermesMetrics metrics, Trackers trackers) {
        this.metrics = metrics;
        this.trackers = trackers;
    }

    public void closeInflightMetrics(MessageBatch batch, Subscription subscription) {
        this.metrics.decrementInflightCounter(subscription, batch.size());
        this.metrics.inflightTimeHistogram(subscription).update(batch.getLifetime());
    }

    public void markSendingResult(MessageBatch batch, Subscription subscription, MessageSendingResult result) {
        this.metrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
        if (result.succeeded()) {
            this.markDelivered(batch, subscription);
        } else {
            this.markDiscarded(batch, subscription, "Retry policy exhausted with status code " + result.getStatusCode());
        }
    }

    private void markDelivered(MessageBatch batch, Subscription subscription) {
        this.metrics.meter("meter").mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic", subscription.getTopicName()).mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic.$subscription.batch", subscription.getTopicName(), subscription.getName()).mark();
        this.metrics.counter("delivered.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).inc((long)batch.size());
        batch.getMessagesMetadata().forEach(m -> this.trackers.get(subscription).logSent(m));
    }

    public void markDiscarded(MessageBatch batch, Subscription subscription, String reason) {
        this.metrics.counter("discarded.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).inc((long)batch.size());
        this.metrics.meter("discarded-meter").mark((long)batch.size());
        this.metrics.meter("discarded-meter.$group.$topic", subscription.getTopicName()).mark((long)batch.size());
        this.metrics.meter("discarded-meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark((long)batch.size());
        batch.getMessagesMetadata().forEach(m -> this.trackers.get(subscription).logDiscarded(m, reason));
    }

    public void markFailed(MessageBatch batch, Subscription subscription, MessageSendingResult result) {
        this.metrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
        this.metrics.meter("failed-meter.$subscription", subscription.getTopicName(), subscription.getName()).mark();
        this.registerFailureMetrics(subscription, result);
        batch.getMessagesMetadata().forEach(m -> this.trackers.get(subscription).logFailed(m, result.getRootCause()));
    }

    private void registerFailureMetrics(Subscription subscription, MessageSendingResult result) {
        if (result.hasHttpAnswer()) {
            this.metrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
        } else {
            (result.isTimeout() ? this.metrics.consumerErrorsTimeoutMeter(subscription) : this.metrics.consumerErrorsOtherMeter(subscription)).mark();
        }
    }

    public void markDiscarded(MessageMetadata messageMetadata, Subscription subscription, String reason) {
        TopicName topicName = TopicName.fromQualifiedName((String)messageMetadata.getTopic());
        this.metrics.counter("discarded.$group.$topic.$subscription", topicName, messageMetadata.getSubscription()).inc();
        this.metrics.meter("discarded-meter").mark();
        this.metrics.meter("discarded-meter.$group.$topic", topicName).mark();
        this.metrics.meter("discarded-meter.$group.$topic.$subscription", topicName, messageMetadata.getSubscription()).mark();
        this.metrics.decrementInflightCounter(subscription);
        this.trackers.get(subscription).logDiscarded(messageMetadata, reason);
    }
}

