/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver.kafka;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetsStorage;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.OffsetsStorageType;

public class OffsetStoragesFactory
implements Factory<List<OffsetsStorage>> {
    private final OffsetsStorage kafkaOffsetsStorage;
    private final OffsetsStorage zookeeperOffsetsStorage;
    private final boolean dualCommitEnabled;
    private final OffsetsStorageType offsetStorageType;

    @Inject
    public OffsetStoragesFactory(@Named(value="kafkaOffsetsStorage") OffsetsStorage kafkaOffsetsStorage, @Named(value="zookeeperOffsetsStorage") OffsetsStorage zookeeperOffsetsStorage, ConfigFactory configFactory) {
        this.zookeeperOffsetsStorage = zookeeperOffsetsStorage;
        this.kafkaOffsetsStorage = kafkaOffsetsStorage;
        this.dualCommitEnabled = configFactory.getBooleanProperty(Configs.KAFKA_CONSUMER_DUAL_COMMIT_ENABLED);
        this.offsetStorageType = OffsetsStorageType.valueOf(configFactory.getStringProperty(Configs.KAFKA_CONSUMER_OFFSETS_STORAGE).toUpperCase());
    }

    public List<OffsetsStorage> provide() {
        ArrayList offsetsStorages = Lists.newArrayList();
        if (this.dualCommitEnabled || OffsetsStorageType.ZOOKEEPER == this.offsetStorageType) {
            offsetsStorages.add(this.zookeeperOffsetsStorage);
        }
        if (this.dualCommitEnabled || OffsetsStorageType.KAFKA == this.offsetStorageType) {
            offsetsStorages.add(this.kafkaOffsetsStorage);
        }
        return Collections.unmodifiableList(offsetsStorages);
    }

    public void dispose(List<OffsetsStorage> instance) {
    }
}

