/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionOffsetCommitQueues;
import pl.allegro.tech.hermes.consumers.consumer.result.AbstractHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultErrorHandler
extends AbstractHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final Clock clock;
    private final Trackers trackers;
    private final String cluster;

    public DefaultErrorHandler(SubscriptionOffsetCommitQueues offsetHelper, HermesMetrics hermesMetrics, UndeliveredMessageLog undeliveredMessageLog, Clock clock, Trackers trackers, String cluster) {
        super(offsetHelper, hermesMetrics);
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.clock = clock;
        this.trackers = trackers;
        this.cluster = cluster;
    }

    @Override
    public void handleDiscarded(Message message, Subscription subscription, MessageSendingResult result) {
        if (!result.hasHttpAnswer() && !result.isTimeout()) {
            LOGGER.warn("Abnormal delivery failure: subscription: {}; cause: {}; endpoint: {}; messageId: {}; partition: {}; offset: {}", new Object[]{subscription.getId(), result.getRootCause(), subscription.getEndpoint(), message.getId(), message.getPartition(), message.getOffset(), result.getFailure()});
        }
        this.offsetHelper.remove(message);
        this.updateMeters(subscription);
        this.updateMetrics("discarded.$group.$topic.$subscription", message, subscription);
        this.undeliveredMessageLog.add(SentMessageTrace.createUndeliveredMessage((Subscription)subscription, (String)new String(message.getData()), (Throwable)result.getFailure(), (Long)this.clock.millis(), (Integer)message.getPartition(), (Long)message.getOffset(), (String)this.cluster));
        this.trackers.get(subscription).logDiscarded(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void updateMeters(Subscription subscription) {
        this.hermesMetrics.meter("discarded-meter").mark();
        this.hermesMetrics.meter("discarded-meter.$group.$topic", subscription.getTopicName()).mark();
        this.hermesMetrics.meter("discarded-meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark();
    }

    @Override
    public void handleFailed(Message message, Subscription subscription, MessageSendingResult result) {
        this.hermesMetrics.meter("failed-meter.$subscription", subscription.getTopicName(), subscription.getName()).mark();
        this.registerFailureMetrics(subscription, result);
        this.trackers.get(subscription).logFailed(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void registerFailureMetrics(Subscription subscription, MessageSendingResult result) {
        if (result.hasHttpAnswer()) {
            this.hermesMetrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
        } else if (result.isTimeout()) {
            this.hermesMetrics.consumerErrorsTimeoutMeter(subscription).mark();
        } else {
            this.hermesMetrics.consumerErrorsOtherMeter(subscription).mark();
        }
    }
}

