/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadAlgorithm;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkTracker;
import pl.allegro.tech.hermes.consumers.supervisor.workload.mirror.LegacyMirroringSupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.mirror.MirroringSupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.SelectiveSupervisorController;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class SupervisorControllerFactory
implements Factory<SupervisorController> {
    private final ConfigFactory configs;
    private final Map<String, Provider<SupervisorController>> availableImplementations;

    @Inject
    public SupervisorControllerFactory(@Named(value="hermesCurator") CuratorFramework curator, SubscriptionsCache subscriptionsCache, WorkTracker workTracker, ConsumersSupervisor supervisor, ZookeeperAdminCache adminCache, HermesMetrics metrics, ConfigFactory configs) {
        this.configs = configs;
        this.availableImplementations = ImmutableMap.of((Object)"legacy.mirror", () -> new LegacyMirroringSupervisorController(supervisor, subscriptionsCache, adminCache, configs), (Object)"mirror", () -> new MirroringSupervisorController(supervisor, subscriptionsCache, workTracker, adminCache, configs), (Object)"selective", () -> new SelectiveSupervisorController(supervisor, subscriptionsCache, workTracker, SupervisorControllerFactory.createConsumersRegistry(configs, curator), adminCache, Executors.newFixedThreadPool(configs.getIntProperty(Configs.CONSUMER_WORKLOAD_ASSIGNMENT_PROCESSING_THREAD_POOL_SIZE)), configs, metrics));
    }

    private static ConsumerNodesRegistry createConsumersRegistry(ConfigFactory configs, CuratorFramework curator) {
        return new ConsumerNodesRegistry(curator, Executors.newSingleThreadExecutor(), new ZookeeperPaths(configs.getStringProperty(Configs.ZOOKEEPER_ROOT)).consumersRegistryPath(configs.getStringProperty(Configs.KAFKA_CLUSTER_NAME)), configs.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID));
    }

    public SupervisorController provide() {
        return (SupervisorController)Optional.ofNullable(this.availableImplementations.get(this.configs.getStringProperty(Configs.CONSUMER_WORKLOAD_ALGORITHM))).orElseThrow(ConsumerWorkloadAlgorithm.UnsupportedConsumerWorkloadAlgorithm::new).get();
    }

    public void dispose(SupervisorController instance) {
    }
}

