/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class MessageSendingResult {
    public static final String CAUSE_UNKNOWN = "unknown";
    private int statusCode;
    private Throwable failure;
    private boolean loggable = false;
    private Response.Status.Family responseFamily;
    private Optional<Long> retryAfterMillis = Optional.empty();

    public MessageSendingResult(Throwable failure) {
        this.failure = failure;
    }

    public MessageSendingResult(Throwable failure, boolean loggable) {
        this(failure);
        this.loggable = loggable;
    }

    public MessageSendingResult(Result result) {
        this(result.getFailure());
        if (result.getResponse() != null) {
            this.initializeForStatusCode(result.getResponse().getStatus());
            if (this.isRetryLater()) {
                this.initializeRetryAfterMillis(result);
            }
        }
    }

    public MessageSendingResult(int statusCode) {
        this.initializeForStatusCode(statusCode);
    }

    public MessageSendingResult(int statusCode, long retryAfterMillis) {
        this.initializeForStatusCode(statusCode);
        if (this.isRetryLater() && retryAfterMillis >= 0L) {
            this.retryAfterMillis = Optional.of(retryAfterMillis);
        }
    }

    public boolean succeeded() {
        return this.failure == null;
    }

    public boolean isClientError() {
        return this.isInFamily(Response.Status.Family.CLIENT_ERROR);
    }

    public boolean isRetryLater() {
        return this.statusCode == Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    }

    private void initializeForStatusCode(int statusCode) {
        this.statusCode = statusCode;
        this.responseFamily = Response.Status.Family.familyOf((int)statusCode);
        if (this.failure == null && !this.isInFamily(Response.Status.Family.SUCCESSFUL)) {
            this.failure = new InternalProcessingException("Message sending failed with status code:" + statusCode);
        }
    }

    private void initializeRetryAfterMillis(Result result) {
        HttpFields headers = result.getResponse().getHeaders();
        if (headers.contains(HttpHeader.RETRY_AFTER)) {
            try {
                int seconds = Integer.parseInt(headers.get(HttpHeader.RETRY_AFTER));
                if (seconds >= 0) {
                    this.retryAfterMillis = Optional.of(TimeUnit.SECONDS.toMillis(seconds));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isInFamily(Response.Status.Family family) {
        Preconditions.checkNotNull((Object)family);
        return family.equals((Object)this.responseFamily);
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public String getRootCause() {
        return this.failure != null ? Throwables.getRootCause((Throwable)this.failure).getMessage() : CAUSE_UNKNOWN;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean hasHttpAnswer() {
        return this.getStatusCode() != 0;
    }

    public boolean isTimeout() {
        return this.getFailure() instanceof TimeoutException;
    }

    public boolean isLoggable() {
        return this.loggable;
    }

    public Optional<Long> getRetryAfterMillis() {
        return this.retryAfterMillis;
    }

    public static MessageSendingResult succeededResult() {
        return new MessageSendingResult(Response.Status.OK.getStatusCode());
    }

    public static MessageSendingResult failedResult(Throwable cause) {
        return new MessageSendingResult(cause);
    }

    public static MessageSendingResult failedResult(int statusCode) {
        return new MessageSendingResult(statusCode);
    }

    public static MessageSendingResult loggedFailResult(Throwable cause) {
        return new MessageSendingResult(cause, true);
    }

    public static MessageSendingResult retryAfter(int seconds) {
        return new MessageSendingResult(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), TimeUnit.SECONDS.toMillis(seconds));
    }
}

