/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.mirror;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.admin.AdminOperationsCallback;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionCallback;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;

public class LegacyMirroringSupervisorController
implements SupervisorController {
    private final ConsumersSupervisor supervisor;
    private final SubscriptionsCache subscriptionsCache;
    private final ZookeeperAdminCache adminCache;
    private ConfigFactory configFactory;
    private static final Logger logger = LoggerFactory.getLogger(LegacyMirroringSupervisorController.class);

    public LegacyMirroringSupervisorController(ConsumersSupervisor supervisor, SubscriptionsCache subscriptionsCache, ZookeeperAdminCache adminCache, ConfigFactory configFactory) {
        this.supervisor = supervisor;
        this.subscriptionsCache = subscriptionsCache;
        this.adminCache = adminCache;
        this.configFactory = configFactory;
    }

    @Override
    public void onSubscriptionCreated(Subscription subscription) {
        this.supervisor.assignConsumerForSubscription(subscription);
    }

    @Override
    public void onSubscriptionRemoved(Subscription subscription) {
        this.supervisor.deleteConsumerForSubscriptionName(subscription.toSubscriptionName());
    }

    @Override
    public void onSubscriptionChanged(Subscription subscription) {
        this.supervisor.notifyConsumerOnSubscriptionUpdate(subscription);
    }

    @Override
    public void start() throws Exception {
        this.adminCache.start();
        this.adminCache.addCallback((AdminOperationsCallback)this);
        this.subscriptionsCache.start((Collection<? extends SubscriptionCallback>)ImmutableList.of((Object)this));
        this.supervisor.start();
        logger.info("Consumer boot complete. Workload config: [{}]", (Object)this.configFactory.print(new Configs[]{Configs.CONSUMER_WORKLOAD_ALGORITHM}));
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.supervisor.shutdown();
    }

    public void onRetransmissionStarts(SubscriptionName subscription) throws Exception {
        this.supervisor.retransmit(subscription);
    }

    public void restartConsumer(SubscriptionName subscription) throws Exception {
        this.supervisor.restartConsumer(subscription);
    }
}

