/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.selective;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.cache.zookeeper.StartableCache;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class ConsumerNodesRegistry
extends StartableCache
implements PathChildrenCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerNodesRegistry.class);
    private final CuratorFramework curatorClient;
    private final String consumerNodeId;
    private final String prefix;
    private final LeaderLatch leaderLatch;

    public ConsumerNodesRegistry(CuratorFramework curatorClient, ExecutorService executorService, String prefix, String consumerNodeId) {
        super(curatorClient, ConsumerNodesRegistry.getNodesPath(prefix), executorService);
        this.curatorClient = curatorClient;
        this.consumerNodeId = consumerNodeId;
        this.prefix = prefix;
        this.leaderLatch = new LeaderLatch(curatorClient, this.getLeaderPath(), consumerNodeId);
    }

    public void start() throws Exception {
        this.getListenable().addListener((Object)this);
        super.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        switch (event.getType()) {
            case INITIALIZED: 
            case CONNECTION_RECONNECTED: {
                if (this.isRegistered(this.consumerNodeId)) break;
                this.registerConsumerNode();
            }
        }
    }

    public boolean isRegistered(String consumerNodeId) {
        try {
            return this.curatorClient.checkExists().forPath(this.getNodePath(consumerNodeId)) != null;
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    private void registerConsumerNode() {
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.getNodePath(this.consumerNodeId));
            logger.info("Registered in consumer nodes registry as {}", (Object)this.consumerNodeId);
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    public void registerLeaderLatchListener(LeaderLatchListener ... leaderListener) {
        try {
            this.leaderLatch.start();
            Arrays.stream(leaderListener).forEach(arg_0 -> ((LeaderLatch)this.leaderLatch).addListener(arg_0));
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    private String getNodePath(String consumerNodeId) {
        return ConsumerNodesRegistry.getNodesPath(this.prefix) + "/" + consumerNodeId;
    }

    private static String getNodesPath(String prefix) {
        return prefix + "/nodes";
    }

    private String getLeaderPath() {
        return this.prefix + "/leader";
    }

    public boolean isLeader() {
        return this.curatorClient.getZookeeperClient().isConnected() && this.leaderLatch.hasLeadership();
    }

    public List<String> list() {
        return this.getCurrentData().stream().map(data -> StringUtils.substringAfterLast((String)data.getPath(), (String)"/")).collect(Collectors.toList());
    }

    public String getId() {
        return this.consumerNodeId;
    }
}

