/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.chain.FilterResult;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class FilteredMessageHandler {
    private final ConsumerRateLimiter consumerRateLimiter;
    private final Trackers trackers;
    private final HermesMetrics metrics;
    private static final Logger logger = LoggerFactory.getLogger(FilteredMessageHandler.class);

    public FilteredMessageHandler(ConsumerRateLimiter consumerRateLimiter, Trackers trackers, HermesMetrics metrics) {
        this.consumerRateLimiter = consumerRateLimiter;
        this.trackers = trackers;
        this.metrics = metrics;
    }

    public void handle(FilterResult result, Message message, Subscription subscription, Consumer<SubscriptionPartitionOffset> committer) {
        if (result.isFiltered()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Message filtered for subscription {} {}", (Object)subscription.getQualifiedName(), (Object)result);
            }
            committer.accept(SubscriptionPartitionOffset.subscriptionPartitionOffset(message, subscription));
            this.updateMetrics(message, subscription);
            if (subscription.isTrackingEnabled()) {
                this.trackers.get(subscription).logFiltered(MessageConverter.toMessageMetadata(message, subscription), result.getFilterType().get());
            }
            this.consumerRateLimiter.acquire();
        }
    }

    protected void updateMetrics(Message message, Subscription subscription) {
        this.metrics.meter("meter.$group.$topic.$subscription.filtered").mark();
        this.metrics.counter("filtered.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).inc();
    }
}

