/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;

class RunningConsumerProcesses {
    private final Map<SubscriptionName, RunningProcess> processes = new ConcurrentHashMap<SubscriptionName, RunningProcess>();

    RunningConsumerProcesses() {
    }

    void add(ConsumerProcess process, Future executionHandle) {
        this.processes.put(process.getSubscriptionName(), new RunningProcess(process, executionHandle));
    }

    void remove(SubscriptionName subscriptionName) {
        this.processes.remove(subscriptionName);
    }

    void remove(ConsumerProcess process) {
        this.processes.remove(process.getSubscriptionName());
    }

    Future getExecutionHandle(SubscriptionName subscriptionName) {
        return this.processes.get((Object)subscriptionName).executionHandle;
    }

    ConsumerProcess getProcess(SubscriptionName subscriptionName) {
        return this.processes.get((Object)subscriptionName).process;
    }

    boolean hasProcess(SubscriptionName subscriptionName) {
        return this.processes.containsKey(subscriptionName);
    }

    Stream<ConsumerProcess> stream() {
        return this.processes.values().stream().map(p -> p.process);
    }

    Set<SubscriptionName> existingConsumers() {
        return this.processes.keySet();
    }

    public List<String> listRunningSubscriptions() {
        return this.processes.keySet().stream().map(SubscriptionName::getQualifiedName).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }

    public Integer count() {
        return this.processes.size();
    }

    private static class RunningProcess {
        ConsumerProcess process;
        Future executionHandle;

        public RunningProcess(ConsumerProcess process, Future executionHandle) {
            this.process = process;
            this.executionHandle = executionHandle;
        }
    }
}

