/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.List;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;

public class SubscriptionAssignmentRegistry
implements SubscriptionAssignmentAware {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionAssignmentRegistry.class);
    public static final byte[] AUTO_ASSIGNED_MARKER = "AUTO_ASSIGNED".getBytes();
    private final CuratorFramework curator;
    private final SubscriptionAssignmentPathSerializer pathSerializer;
    private final SubscriptionAssignmentCache subscriptionAssignmentCache;

    public SubscriptionAssignmentRegistry(CuratorFramework curator, SubscriptionAssignmentCache subscriptionAssignmentCache, SubscriptionAssignmentPathSerializer pathSerializer) {
        this.curator = curator;
        this.pathSerializer = pathSerializer;
        this.subscriptionAssignmentCache = subscriptionAssignmentCache;
    }

    public void start() throws Exception {
        this.subscriptionAssignmentCache.registerAssignmentCallback(this);
    }

    public boolean isStarted() {
        return this.subscriptionAssignmentCache.isStarted();
    }

    @Override
    public void onSubscriptionAssigned(SubscriptionName subscriptionName) {
    }

    @Override
    public void onAssignmentRemoved(SubscriptionName subscriptionName) {
        this.removeSubscriptionEntryIfEmpty(subscriptionName);
    }

    @Override
    public Optional<String> watchedConsumerId() {
        return Optional.empty();
    }

    public void registerAssignmentCallback(SubscriptionAssignmentAware callback) {
        this.subscriptionAssignmentCache.registerAssignmentCallback(callback);
    }

    boolean isAssignedTo(String nodeId, SubscriptionName subscription) {
        return this.subscriptionAssignmentCache.isAssignedTo(nodeId, subscription);
    }

    public SubscriptionAssignmentView createSnapshot() {
        return this.subscriptionAssignmentCache.createSnapshot();
    }

    void dropAssignment(SubscriptionAssignment assignment) {
        String message = String.format("Dropping assignment [consumer=%s, subscription=%s]", assignment.getConsumerNodeId(), assignment.getSubscriptionName().getQualifiedName());
        logger.info(message);
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        }, message);
    }

    void addPersistentAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.PERSISTENT);
    }

    void addEphemeralAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.EPHEMERAL);
    }

    private void removeSubscriptionEntryIfEmpty(SubscriptionName subscriptionName) {
        String message = String.format("Removing empty assignment node [subscription=%s]", subscriptionName.getQualifiedName());
        this.askCuratorPolitely(() -> {
            if (((List)this.curator.getChildren().forPath(this.pathSerializer.serialize(subscriptionName))).isEmpty()) {
                logger.info(message);
                this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(subscriptionName));
            }
        }, message);
    }

    private void addAssignment(SubscriptionAssignment assignment, CreateMode createMode) {
        String message = String.format("Adding assignment [consumer=%s, subscription=%s]", assignment.getConsumerNodeId(), assignment.getSubscriptionName().getQualifiedName());
        logger.info(message);
        this.askCuratorPolitely(() -> {
            String path = this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId());
            ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, AUTO_ASSIGNED_MARKER);
        }, message);
    }

    private void askCuratorPolitely(CuratorTask task, String description) {
        try {
            task.run();
        }
        catch (KeeperException.NoNodeException | KeeperException.NodeExistsException ex) {
            logger.warn("An error occurred while writing to assignment registry, ignoring. Action: {}", (Object)description, (Object)ex);
        }
        catch (Exception ex) {
            logger.error("An error occurred while writing to assignment registry. Action: {}", (Object)description, (Object)ex);
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    static interface CuratorTask {
        public void run() throws Exception;
    }
}

