/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import com.google.common.util.concurrent.RateLimiter;
import java.time.Clock;
import java.util.Objects;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimitSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculationResult;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculatorFactory;

public class SerialConsumerRateLimiter
implements ConsumerRateLimiter {
    private Subscription subscription;
    private final HermesMetrics hermesMetrics;
    private final ConsumerRateLimitSupervisor rateLimitSupervisor;
    private final RateLimiter rateLimiter;
    private final RateLimiter filterRateLimiter;
    private final OutputRateCalculator outputRateCalculator;
    private final SendCounters sendCounters;
    private OutputRateCalculator.Mode currentMode;

    public SerialConsumerRateLimiter(Subscription subscription, OutputRateCalculatorFactory outputRateCalculatorFactory, HermesMetrics hermesMetrics, ConsumerRateLimitSupervisor rateLimitSupervisor, Clock clock) {
        this.subscription = subscription;
        this.hermesMetrics = hermesMetrics;
        this.rateLimitSupervisor = rateLimitSupervisor;
        this.sendCounters = new SendCounters(clock);
        this.outputRateCalculator = outputRateCalculatorFactory.createCalculator(subscription, this.sendCounters);
        this.currentMode = OutputRateCalculator.Mode.NORMAL;
        this.rateLimiter = RateLimiter.create((double)this.calculateInitialRate().rate());
        this.filterRateLimiter = RateLimiter.create((double)subscription.getSerialSubscriptionPolicy().getRate().intValue());
    }

    @Override
    public void initialize() {
        this.outputRateCalculator.start();
        this.adjustConsumerRate();
        this.hermesMetrics.registerOutputRateGauge(this.subscription.getTopicName(), this.subscription.getName(), () -> ((RateLimiter)this.rateLimiter).getRate());
        this.rateLimitSupervisor.register(this);
    }

    @Override
    public void shutdown() {
        this.hermesMetrics.unregisterOutputRateGauge(this.subscription.getTopicName(), this.subscription.getName());
        this.rateLimitSupervisor.unregister(this);
        this.outputRateCalculator.shutdown();
    }

    @Override
    public void acquire() {
        this.rateLimiter.acquire();
        this.sendCounters.incrementAttempted();
    }

    @Override
    public void acquireFiltered() {
        this.filterRateLimiter.acquire();
    }

    @Override
    public void adjustConsumerRate() {
        OutputRateCalculationResult result = this.recalculate();
        this.rateLimiter.setRate(result.rate());
        this.currentMode = result.mode();
        this.sendCounters.reset();
    }

    private OutputRateCalculationResult calculateInitialRate() {
        return this.outputRateCalculator.recalculateRate(this.sendCounters, this.currentMode, 0.0);
    }

    private OutputRateCalculationResult recalculate() {
        return this.outputRateCalculator.recalculateRate(this.sendCounters, this.currentMode, this.rateLimiter.getRate());
    }

    @Override
    public void updateSubscription(Subscription newSubscription) {
        this.subscription = newSubscription;
        this.filterRateLimiter.setRate((double)newSubscription.getSerialSubscriptionPolicy().getRate().intValue());
        this.outputRateCalculator.updateSubscription(newSubscription);
    }

    @Override
    public void registerSuccessfulSending() {
        this.sendCounters.incrementSuccesses();
    }

    @Override
    public void registerFailedSending() {
        this.sendCounters.incrementFailures();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerialConsumerRateLimiter that = (SerialConsumerRateLimiter)o;
        return Objects.equals(this.subscription.getQualifiedName(), that.subscription.getQualifiedName());
    }

    public int hashCode() {
        return Objects.hashCode(this.subscription.getQualifiedName());
    }
}

