/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.idleTime;

import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.consumers.consumer.idleTime.IdleTimeCalculator;

public class ExponentiallyGrowingIdleTimeCalculator
implements IdleTimeCalculator {
    private final long base;
    private final long initialIdleTime;
    private final long maxIdleTime;
    private long currentIdleTime;

    public ExponentiallyGrowingIdleTimeCalculator(long initialIdleTime, long maxIdleTime) {
        this(2L, initialIdleTime, maxIdleTime);
    }

    public ExponentiallyGrowingIdleTimeCalculator(long base, long initialIdleTime, long maxIdleTime) {
        Preconditions.checkArgument((base > 0L ? 1 : 0) != 0, (Object)"base should be greater than zero");
        Preconditions.checkArgument((initialIdleTime > 0L ? 1 : 0) != 0, (Object)"initialIdleTime should be greater than zero");
        Preconditions.checkArgument((maxIdleTime > 0L ? 1 : 0) != 0, (Object)"maxIdleTime should be greater than zero");
        Preconditions.checkArgument((initialIdleTime <= maxIdleTime ? 1 : 0) != 0, (Object)"maxIdleTime should be grater or equal initialIdleTime");
        this.base = base;
        this.initialIdleTime = initialIdleTime;
        this.maxIdleTime = maxIdleTime;
        this.currentIdleTime = initialIdleTime;
    }

    @Override
    public long increaseIdleTime() {
        long previousIdleTime = this.currentIdleTime;
        this.currentIdleTime = Math.min(this.currentIdleTime * this.base, this.maxIdleTime);
        return previousIdleTime;
    }

    @Override
    public long getIdleTime() {
        return this.currentIdleTime;
    }

    @Override
    public void reset() {
        this.currentIdleTime = this.initialIdleTime;
    }
}

